<?PHP
ini_set("memory_limit", "256M");
$debugServer = $_SERVER["HTTP_HOST"] != "www.montclair.edu";

$outputDirectory = $_SERVER["DOCUMENT_ROOT"]."/responsive-media/cache";
$validSizes = array(
	"hero" => array(
		array("w" => 320, "h" => 180),
		array("w" => 480, "h" => 270),
		array("w" => 720, "h" => 405),
		array("w" => 1280, "h" => 720)
	),
	"imagegallery" => array(
		array("w" => 300, "h" => 300)
	),
	"generic" => array (
		array("w" => 250, "h" => null),
		array("w" => 350, "h" => null),
		array("w" => 500, "h" => null),
		array("w" => 750, "h" => null),
		array("w" => 1000, "h" => null),
		array("w" => 1250, "h" => null),
		array("w" => 1500, "h" => null),
		array("w" => 1800, "h" => null)
	),
	"wide" => array (
		array("w" => 250, "h" => 140),
		array("w" => 350, "h" => 196),
		array("w" => 500, "h" => 281),
		array("w" => 750, "h" => 421),
		array("w" => 1000, "h" => 562),
		array("w" => 1250, "h" => 703),
		array("w" => 1500, "h" => 843),
		array("w" => 1800, "h" => 1012)
	)
);
$stampImage = false;

/**
function CheckOptions
	arguments		none
	returns			on success		PHP object with querystring options
					on failure		false
	description		Retrieves and validates querystring options
**/
function CheckOptions() {
	global $validSizes, $debugServer;

	// if the required options aren't in place, short circuit
	if (!isset($_GET["f"])) return false;
	if (!isset($_GET["type"]) || !isset($validSizes[$_GET["type"]])) return false;
	if (!isset($_GET["size"]) || !is_numeric($_GET["size"]) || !isset($validSizes[$_GET["type"]][$_GET["size"]])) return false;
	
	// if it looks like the visitor is trying to snoop around our filesystem,
	// short circuit
	if (strpos($_GET["f"], "..")!==false) return false;

	// create a variable to hold our options
	$opts = (object)null;
	
	// get scale
	$scale = 1;
	$opts->quality = 85;
	if (isset($_GET["scale"]) && $_GET["scale"]=="2x") {
		$opts->quality = 60;
		$scale = 2;
	}
	$opts->scale = $scale;
	
	// get size
	$opts->width = $validSizes[$_GET["type"]][$_GET["size"]]["w"]*$scale;
	$opts->height = $validSizes[$_GET["type"]][$_GET["size"]]["h"]*$scale;

	// store the querystring size and type for later reference
	$opts->getSize = $_GET["size"];
	$opts->type = $_GET["type"];

	// get the file path
	$opts->path = $_GET["f"];
    
	// get the file location (only used to output cache file)
	$opts->fileLocation = substr($opts->path, 0, strrpos($opts->path, "/"));

	// set the initial location to load from
	$opts->loadFrom = $_SERVER["DOCUMENT_ROOT"].$opts->path;

	// correct for WordPress network
	if (strpos($opts->path, "/wp-content/") !== false) {
		// $opts->path = substr($opts->path, strpos($opts->path, "/wp-content/"));
		$opts->loadFrom = $_SERVER["DOCUMENT_ROOT"].substr($opts->path, strpos($opts->path, "/wp-content/"));
	}
    
	// get the image size - this will determine if the path
	// is a reference to a valid image
	$opts->tempFile = false;
	$imageSize = @getimagesize($opts->loadFrom);
	$exif = null;
	if ($imageSize === false && $debugServer) {
		// it's not local, but let's see if it's on production
		$tmp = file_get_contents("http://www.montclair.edu".$opts->path);
		if ($tmp) {
			$fname = explode("/",$opts->path);
			$fname = $fname[count($fname)-1];
			$opts->loadFrom = dirname(__FILE__)."/cache/tmp_".time()."_".$fname;
			$opts->tempFile = $opts->loadFrom;
			file_put_contents($opts->tempFile, $tmp);
			$imageSize = @getimagesize($opts->loadFrom);
			// suppress warning - it's okay that this doesn't
			// return data for PNG
			$exif = @exif_read_data($opts->loadFrom);
		}
	} else {
		// suppress warning - it's okay that this doesn't
		// return data for PNG
		$exif = @exif_read_data($opts->loadFrom);
	}
	if ($imageSize === false) return false;
	
	$opts->size = $imageSize;
	$opts->exif = $exif;
	
	/*
	// moving this to later so that we can check exif orientation first
	if ($opts->height == null) {
		$opts->height = floor($opts->width*$opts->size[1]/$opts->size[0]);
	}
	*/
	
	return $opts;
}

/**
function EndWidthImage
	arguments		inFilename		Filename of image
					inMime			Mime type of image (no use calling getimagesize() twice
	returns			on success		true
					on failure		false
	description		Checks file against apache request headers, sends appropriate caching information.
					Sends image to user if needed. Exits.
**/
function EndWithImage($inFilename, $inMime) {
	if (is_array($inMime) ){
		if (isset($inMime["mime"])) $inMime = $inMime["mime"];
		else $inMime = "image/jpeg";
	}
	// code copied from http://php.net/manual/en/function.header.php

	// Getting headers sent by the client.
    $headers = apache_request_headers();

    // Checking if the client is validating his cache and if it is current.
    if (isset($headers['If-Modified-Since']) && (strtotime($headers['If-Modified-Since']) == filemtime($inFilename))) {
        // Client's cache IS current, so we just respond '304 Not Modified'.
        header('Last-Modified: '.gmdate('D, d M Y H:i:s', filemtime($inFilename)).' GMT', true, 304);
    } else {
        // Image not cached or cache outdated, we respond '200 OK' and output the image.
        header('Last-Modified: '.gmdate('D, d M Y H:i:s', filemtime($inFilename)).' GMT', true, 200);
		header("Expires: ".gmdate('D, d M Y H:i:s', strtotime("+1 Month"))." GMT", true, 200);
        header('Content-Length: '.filesize($inFilename));
        header('Content-Type: '.$inMime);
        echo(file_get_contents($inFilename));
    }
	exit("");
}


/**
function OpenImage
	arguments		$inPath			Path to an image file
					$inInfo			return value from getimagesize
	returns			on success		a GD image resource
					on failure		false
	description		Opens an image using GD based on the image type.
**/
function OpenImage ($inPath, $inInfo) {
	$ret = false;
	switch($inInfo[2]) {
		case IMAGETYPE_JPEG:
			$ret = imagecreatefromjpeg($inPath);
			break;
		case IMAGETYPE_GIF:
			$ret = imagecreatefromgif($inPath);
			break;
		case IMAGETYPE_PNG:
			$ret = imagecreatefrompng($inPath);
			break;
		default: 
			break;
	}
	return $ret;
}

function OrientImage($inImage, $inOpts) {
	if (!isset($inOpts->exif) && $inOpts->exif !== false) return $inImage;

	if (!isset($inOpts->exif["Orientation"])) return $inImage;

	$angles = array("8" => 90, "3" => 180, "6" => 270);
	if (!isset($angles[$inOpts->exif["Orientation"]])) return $inImage;

	$bgcol = imagecolorallocate($inImage, 0, 0, 0);

	$ret = imagerotate($inImage, $angles[$inOpts->exif["Orientation"]], $bgcol);
	imagedestroy($inImage);

	return $ret;
}

/**
function ResizeWithCrop
	arguments		$inImage		a GD image resource
					$inWidth		target width
					$inHeight		target height
	returns			on success		a GD image resource of the cropped image
					on failure		false
	description		Resizes and crops image to fit new bounds
**/
function ResizeWithCrop($inImage, $inWidth, $inHeight) {
	// get the original width, height, & aspect
	$sourceWidth = imagesx($inImage);
	$sourceHeight = imagesy($inImage);
	$sourceAspect = $sourceWidth/$sourceHeight;
	
	// get the target aspect
	$destAspect = $inWidth/$inHeight;
	
	// if the destination is wider than the source
	if ($destAspect >= $sourceAspect) {
		$tmpHeight = $sourceWidth/$destAspect;
		
		$tmpImage = imagecreatetruecolor($inWidth, $inHeight);
		imagecopyresampled($tmpImage, $inImage, 0, 0, 0, floor(($sourceHeight-$tmpHeight)/2), $inWidth, $inHeight, $sourceWidth, $tmpHeight);
		
		return $tmpImage;
	} else {
		$tmpWidth = $sourceHeight*$destAspect;
		
		$tmpImage = imagecreatetruecolor($inWidth, $inHeight);
		imagecopyresampled($tmpImage, $inImage, 0, 0, floor(($sourceWidth-$tmpWidth)/2), 0, $inWidth, $inHeight, $tmpWidth, $sourceHeight);
		
		return $tmpImage;
	}
}


// fetch options
$opts = CheckOptions();

// if the options are invalid for any reason, exit
if ($opts === false) {
	header("HTTP/1.0 404 Not Found");

	if (!isset($TemplateLocation)) $TemplateLocation = "/php-template/index.php";
	$PageTitle = "Image Not Found";
	$PageHeaderContents = null;
	$PageBody = null;
	$PageBreadcrumbs = array(
		array("name"=>"Montclair State", "url"=>"/")
	);
	$PageHeaderImage = null;
	$LeftMenuContent = null;
	
	ob_start();
	?>
		<p>The image you're looking for could not be found.</p>
	<?PHP
	$PageBody = ob_get_contents();
	ob_end_clean();
	include($_SERVER["DOCUMENT_ROOT"].$TemplateLocation);
	if ($opts->tempFile) {
		@unlink($opts->tempFile);
	}
	exit("");
}

// find out what the output filename should be for this size and quality
@mkdir($outputDirectory.$opts->fileLocation, 0755, true); // suppress "already exists" warning
// $dstPath = sprintf("%s%s.responsive_%dx%dq%d.jpg", $outputDirectory, $opts->path, $opts->width, $opts->height, $opts->quality);
$dstPath = sprintf("%s%s.%d.%dx.%s.jpg", $outputDirectory,$opts->path, $opts->getSize, $opts->scale, $opts->type);

// if the file doesn't exist OR the source has been updated recently
if (!file_exists($dstPath) || !(filemtime($dstPath)>filemtime($opts->loadFrom))) {

	// open and resize the image
	$myImage = OpenImage($opts->loadFrom, $opts->size);
	$myImage = OrientImage($myImage, $opts);

	// swap width & height if needed
	$a1 = imagesx($myImage)/imagesy($myImage);
	$a2 = $opts->size[0]/$opts->size[1];
	if (($a1>1 && $a2<1) || ($a1<1 && $a2>1)) {
		$tmp = $opts->size[0];
		$opts->size[0] = $opts->size[1];
		$opts->size[1] = $tmp;
	}

	// for open-ended heights, generate a new height
	if ($opts->height == null) {
		$opts->height = floor($opts->width*$opts->size[1]/$opts->size[0]);
	}

	$outImage = ResizeWithCrop($myImage, $opts->width, $opts->height);
	
	if ($stampImage) {
		// write debug info onto image
		$stampString = sprintf("%dx%d q%d", $opts->width, $opts->height, $opts->quality);
		$white = imagecolorallocate($outImage, 255, 255, 255);
		$black = imagecolorallocate($outImage, 0, 0, 0);
		$fontSize = $opts->height/20;
		
		imagettftext($outImage, $fontSize, 0, 2, $fontSize*1.3+1, $black, "Prelude-Medium.ttf", $stampString);
		imagettftext($outImage, $fontSize, 0, 1, $fontSize*1.3+0, $white, "Prelude-Medium.ttf", $stampString);
	}

	// save the image w/ our quality setting
	imagejpeg($outImage, $dstPath, $opts->quality);

	// free memory
	imagedestroy($myImage);
	imagedestroy($outImage);
}

if ($opts->tempFile) {
	unlink($opts->tempFile);
}

// output the generated image
EndWithImage($dstPath, getimagesize($dstPath));
?>
