<?PHP 
if (!function_exists("MSU_CampaignHero")) {
	function MSU_CampaignHero($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("form_heading"=>"Take the Next Step - Contact Us", "id"=>"", "prefill"=>"", "filters"=>"","server"=>"apply.montclair.edu"), $atts, "campaignhero");

		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build slate form
		$slateForm = sprintf("<div id=\"form_%s\">Loading...</div><script>/*<![CDATA[*/var script = document.createElement('script'); script.async = 1; script.src = 'https://%s/register/?id=%s&output=embed&div=form_%s&%s' + ((location.search.length > 1) ? '&' + location.search.substring(1) : ''); var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(script, s);/*]]>*/</script>", $a["id"], $a["server"], $a["id"],$a["id"], $a["prefill"]);
		if (!isset($a["id"]) || empty($a["id"])) $slateForm = "<p><em>Invalid ID supplied for Slate form.</em></p>\n";

		$retval = sprintf("<div class='campaign-hero'><div class='text-area'>%s</div><div class='form-holder'><div class='rfi-form'><h2>%s</h2> %s <p>Your privacy is important to us. We will never share your data with third parties. For more details, please refer to our <a href=\"https://www.montclair.edu/privacy-notice/\">Privacy Policy</a>.</p></div></div></div>", $content, $a["form_heading"], $slateForm);

		if ($a["filters"]) {
			ob_start();
			?>
			<script>
				(function() {
					var tmpData = {"id": "form_<?PHP echo $a["id"];?>"};
					tmpData.filters = new Object;
					<?PHP 
					$filterList = explode("&", $a["filters"]);
					foreach ($filterList as $f) {
						list($key,$val) = explode("=", $f);
						$val = explode(",", $val);
						foreach ($val as $i=>$j) {
							$val[$i] = sprintf("\"%s\"", trim($j));
						}
						echo sprintf("tmpData.filters[\"%s\"] = new Array(%s);",
							$key, implode(",", $val));
					}

					?>

					if (!("MSU_SlateFormList" in window)) {
						window.MSU_SlateFormList = new Array();
					}
					window.MSU_SlateFormList.push(tmpData);
				})();
			</script>
			<?PHP
			$retval .= ob_get_contents();
			ob_end_clean();
		}
				
		return $retval;
	}

	add_shortcode("campaignhero", "MSU_CampaignHero");
	$GLOBALS["MLTS_fix_codes"][]="campaignhero";
}