<?PHP
if (!function_exists("get_header")) exit("Wordpress not loaded.");



// $isMainSite = (network_home_url() == home_url()."/")?true:false;
$isMainSite = (get_current_blog_id()==1);
$isChildTheme = get_stylesheet_directory() != get_template_directory();

function custom_page_title() {	
	global $page, $paged, $isMainSite;


	$isMainSite = (get_current_blog_id()==1);
	/*
	$fullTitle = array();

	ob_start();
	if (is_404()) {
		echo ("Page Not Found");
	} else {
		the_title();
	}
	$pageTitle = ob_get_contents();
	ob_end_clean();
	// Add the blog name.
	// bloginfo( 'name' );
	if (!is_front_page()) $fullTitle[] = $pageTitle;
	if (!$isMainSite) $fullTitle[] = get_option('blogname');
	switch_to_blog(1);
	$fullTitle[] = get_option('blogname');
	restore_current_blog();

	return implode(" - ", $fullTitle);
	*/

	// special case for University homepage
	if ($isMainSite && is_front_page()) {
		return get_option('blogname');
	}


	$retVal = ucwords(wp_title( '-', false, 'right' ));
	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 ) {
		$retVal .= sprintf( __( 'Page %s - ', 'feliciano' ), max( $paged, $page ) );
	}
	$retVal .= get_bloginfo("name");
	if (!$isMainSite) {
		$retVal .= " - ";
		switch_to_blog(1);
		$retVal .= get_option("blogname");
		restore_current_blog();
	}

	// Add the blog name.
	// bloginfo( 'name' );


	$retVal = ucwords($retVal);
	return $retVal;
}

function getOGImageTag($twitter = false) {
	$inURL = get_the_post_thumbnail_url(null, "original");
	if (!$inURL || empty($inURL)) return "";
	$imgID = mpGetIDFromURL($inURL);
	$altText = get_post_meta($imgID, '_wp_attachment_image_alt', true);	

	$inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $inURL);
	$retVal = "";
	$retVal = "<meta property=\"".($twitter?"twitter:image":"og:image")."\" content=\"";
	$retVal .= network_home_url("/responsive-media/cache".$inURL.".5.1x.generic.jpg");
	$retVal .= "\" />\n";
	if (!empty($altText)) {
		$retVal .= sprintf("<meta property=\"%s:image:alt\" content=\"%s\" />\n",
			$twitter?"twitter":"og",
			htmlspecialchars($altText, ENT_QUOTES));
	}
	return $retVal;
}

$DisplayCalendar = false;
if (boolval(get_option("CalendarHomepage")) || (intcheck(get_option("CalendarID"))!==null) ||
	(intcheck(get_option("CalendarListID"))!==null)) {
	$DisplayCalendar = true;
}

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2, user-scalable=yes" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />

		<?PHP 
		if ($_SERVER["HTTP_HOST"]=="www.montclair.edu" 
			&& preg_match("/siteimprove\.com/i", $_SERVER["HTTP_USER_AGENT"], $matches)==0
			&& !dnt_user()) {
			@include (get_template_directory()."/google-tag-manager.php");
		}
		?>

		<title><?php echo custom_page_title(); ?></title>

		<!-- Standard Meta Description for Google Snippet -->
		<?PHP 
			$excerpt = get_the_excerpt();
			if ($excerpt && !empty($excerpt)) {
					$excerpt = htmlspecialchars(html_entity_decode($excerpt), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');
					echo "<meta name=\"description\" content=\"".$excerpt."\" />\n";
			}
		?>

		<!-- Robots no-index, no-follow for old news -->
		<?PHP 
			// find out the max age from the site options
			$archive_after = get_option("ArchiveNewsAfter");
			// if this is a post AND there's a maximum age
			if ("post" == @get_post_type() && is_numeric($archive_after)) {
				// convert the archive age to seconds
				$archive_after = intval($archive_after * 24*60*60);
				// get the post's age in seconds
				$post_age = (time() - strtotime(get_the_date("c")));
				// if this post is "old" then output the robots text
				if ($post_age > $archive_after) {
					echo ("<meta name=\"robots\" content=\"noindex, nofollow\">\n");
				}
			}
		?>

		<!-- Twitter Card Info (uses Open Graph data) -->
		<meta name="twitter:card" content="summary_large_image" />
		<meta name="twitter:site" content="@montclairstateu" />
		<meta name="twitter:title" content="<?PHP echo htmlspecialchars(html_entity_decode(get_the_title()), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>" />
		<?PHP 
			if ($excerpt && !empty($excerpt)) {
					echo "<meta property=\"twitter:description\" content=\"".$excerpt."\" />\n";
			}
		?>
		<?PHP echo getOGImageTag(true); ?>

		<!-- Open Graph Protocol metadata -->
		<meta property="og:type" content="article" />
		<meta property="og:title" content="<?PHP echo htmlspecialchars(html_entity_decode(get_the_title()), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>" />
		<?PHP 
			if ($excerpt && !empty($excerpt)) {
					echo "<meta property=\"og:description\" content=\"".$excerpt."\" />\n";
			}
		?>
		<?PHP echo getOGImageTag();?>
		<meta property="og:url" content="<?PHP echo @get_page_link();?>" />
		
		<!-- <link rel="stylesheet" type="text/css" href="<?PHP echo get_template_directory_uri() ?>/style.css" /> -->
		<?PHP 
		if ($isChildTheme) {
			?>
			<!-- <link rel="stylesheet" type="text/css" href="<?PHP echo get_stylesheet_directory_uri(); ?>/style.css" /> -->
			<?PHP
		}
		?>

		<script type="text/javascript">
			window.themeRoot = "<?PHP echo get_template_directory_uri();?>";
			window.childRoot = "<?PHP echo get_stylesheet_directory_uri();?>";
			/* ensureCSS */
			function ensureCSS(a){var b=document.createElement("div");b.innerHTML='<a href="'+a+'">'+a+"</a>";for(var c=b.firstChild.href,d=document.getElementsByTagName("LINK"),e=0;e<d.length;e++)if(d[e].href==c)return!1;var f=document.createElement("link");return f.rel="stylesheet",f.type="text/css",f.href=c,document.head.appendChild(f),!0}

			<?PHP 
			if ($DisplayCalendar) {
				$CalOpts = array();
				$CalOpts["show"] = true;
				if (boolval(get_option("CalendarHomepage"))) {
					$CalOpts["homepage"] = true;
				} else if (intcheck(get_option("CalendarListID"))!==null) {
					$CalOpts["ListID"] = intcheck(get_option("CalendarListID"));
				} else if (intcheck(get_option("CalendarID"))!==null) {
					$CalOpts["id"] = intcheck(get_option("CalendarID"));
				}
				echo "window.sidebarCalendarOptions =".json_encode($CalOpts).";";
			} ?>
		</script>

		<?PHP wp_head(); ?>
	</head>
	<body <?php body_class($isMainSite?" homepage":""); ?>><div style="height: 0; width: 0; position: absolute; visibility: hidden"><?PHP 
		// include university-wide SVG spritesheet
		echo preg_replace("/[\\r\\n]/i", "", file_get_contents(get_template_directory()."/sprite-sheet.svg"));
		// if this is a child theme and the child theme has a sprite sheet, include that too.
		if ($isChildTheme && file_exists(get_stylesheet_directory()."/sprite-sheet.svg")) {
			echo preg_replace("/[\\r\\n]/i", "", file_get_contents(get_stylesheet_directory()."/sprite-sheet.svg"));
		}
	?></div><nav aria-label="Accessibility Navigation"><!-- Google Tag Manager (noscript) --><noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-PQ6QXHQ" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript><!-- End Google Tag Manager (noscript) --><a href="#content-start" class="a11y-link" id="SkipToContent">Skip to Content</a></nav>
		
		<header class="campagin-header">
			<h1 class="logo-holder" aria-label="Montclair State University"><svg viewBox="0 0 225 45"><use xlink:href="#msu-logo-2023"></use></svg></h1>
		</header>
