<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 *
 */
if (!function_exists("get_header")) exit("Wordpress not loaded.");

get_header(); 
$thumbURL = get_stylesheet_directory_uri()."/404-new.jpg";
$thumbURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $thumbURL);
wp_enqueue_script("error-page-live-search");
?>


<main>
<div class="prpl-hero" style="background-image: url(<?PHP echo "/responsive-media/cache/".$thumbURL.".0.1x.generic.jpg";?>);">
	<img 
			class="mlt-responsive-background"
			src="/responsive-media/cache/<?PHP echo $thumbURL;?>.0.1x.generic.jpg" 
			data-original-image="<?PHP echo $thumbURL;?>" alt="Photo of Rocky on train station bench" />
	<h1>Page Not Found</h1>
</div>
		

<div class="page-middle">
	<div class="prpl-menu-column"><a name="page-menu-start"></a>
		<!-- no nav on 404 pages -->
	</div><!-- div.prpl-menu-column -->
	<div class="prpl-content-column"><a name="content-start"></a>
		<style type="text/css">
			.live-search-output {
				margin: 2em 0em;
			}

			.live-search-output .live-search-result {
				display: block;
				margin: 1em 0em;
			}

			.live-search-output .live-search-result:hover {
				text-decoration: none !important;				
			}

			.live-search-output .live-search-result .title {
				display: block;
				font-size: 1.1em;
			}

			.live-search-output .live-search-result:hover .title {
				text-decoration: underline;
			}

			.live-search-output .live-search-result .url {
				display: block;
				color: rgb(139, 143, 156);
				font-weight: normal;
				font-style: italic;
			}

		</style>
		<p>Whoops! The server was unable to locate a page at <strong><?PHP
			echo htmlspecialchars($_SERVER["REQUEST_URI"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8"); 
		?></strong>. Please check the name and try again.</p>
		<div class="live-search-output"></div>
	</div><!-- div.prpl-content-column -->
</div><!-- div.page-middle -->
</main>


<?php get_footer(); ?>