<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 */
if (!function_exists("get_header")) exit("Wordpress not loaded.");

get_header(); ?>




<?php
	/* Queue the first post, that way we know
	 * what date we're dealing with (if that is the case).
	 *
	 * We reset this later so we can run the loop
	 * properly with a call to rewind_posts().
	 */
	$HeaderImage = null;
	$thumbURL = null;
	$opt = get_option("page_for_posts");
	if ($opt != "0") {
		$news_home_post = get_post(get_option('page_for_posts'));
		$news_home_post->permalink = get_permalink($news_home_post->ID);
		if (has_post_thumbnail($news_home_post->ID)) {
			$thumbID = get_post_thumbnail_id($news_home_post->ID);
			$alt = get_post_meta($thumbID , '_wp_attachment_image_alt', true);
			$thumbURL = wp_get_attachment_url($thumbID);
			$HeaderImage = $thumbURL;
			$thumbURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $thumbURL);
			$thumbURL = "/responsive-media/cache".$thumbURL.".0.1x.generic.jpg";
		}
	} else {
		$news_home_post = new stdClass();
		$news_home_post->permalink = get_bloginfo("url");
		$news_home_post->post_title = get_bloginfo("title");
		$HeaderImage = '/wp-content/themes/msu-prpl/default-header.jpg';
		$thumbURL = "/responsive-media/cache".$HeaderImage.".0.1x.generic.jpg";
		$alt = "Photo of University Hall";
	}

$LeftMenu = null;
/*
// build the left menu (for news, let's just display site nav in full on left)
$tmp = wp_get_nav_menu_items("Header Menu");
$tmp = MSU_CollectChildren($tmp);
$tmp = MSU_BuildLeftMenu($tmp, get_option("page_on_front"), true);

$LeftMenu = $tmp; 
*/

		the_post();
	?>
<main>
<div class="page-middle short-hero">
	<div class="prpl-menu-column">
		<nav class="prpl-left-menu" aria-label="Category Menu">
			<?PHP 
			if ($LeftMenu) {
				echo ($LeftMenu);
			} else {
				?>
				<p><a href="<?PHP echo $news_home_post->permalink;?>"><?PHP echo $news_home_post->post_title;?></a></p>
				<?PHP 
					$current_category = get_the_category();
					if (!isset($current_category["cat_ID"])) $current_category["cat_ID"] = null;
					$str = wp_list_categories(array("echo"=>0,"current_category"=>$current_category["cat_ID"]));
					$str = substr($str, stripos($str, "<ul"));
					$str = str_replace("current-cat", "current-page", $str);
					echo($str);
			}
			?>
		</nav>
	</div>
	<div class="prpl-hero short" <?PHP if ($thumbURL) echo("style=\"background-image: url(".$thumbURL.")\""); ?>>
		<?PHP 
		if ($thumbURL) {
			?>
		<img 
				class="mlt-responsive-background"
				src="<?PHP echo $thumbURL;?>" 
				data-original-image="<?PHP echo $HeaderImage;?>" 
				alt="<?PHP echo $alt; ?>"/>
		<?PHP } ?>
		<?PHP if (!boolval(get_option("RepositionH1"))) echo sprintf("<h1 id=\"content-start\">%s</h1>", $news_home_post->post_title); ?>
	</div>
	<div class="prpl-content-column">

	<?PHP
		if (boolval(get_option("RepositionH1"))) echo sprintf("<h1 id=\"content-start\">%s</h1>", $news_home_post->post_title);
		the_archive_title("<h2>", "</h2>");
?>


<div class="article-listing">
<?php
	/* Since we called the_post() above, we need to
	 * rewind the loop back to the beginning that way
	 * we can run the loop properly, in full.
	 */
	rewind_posts();

	/* Run the loop for the archives page to output the posts.
	 * If you want to overload this in a child theme then include a file
	 * called loop-archive.php and that will be used instead.
	 */
	 get_template_part( 'loop', 'archive' );
?>
</div>

	</div>
</div>
</main>



<?php 



get_footer(); ?>
