<?PHP 

if (!defined("BASE64_IMAGE_MAX_RES")) {
	define("BASE64_IMAGE_MAX_RES", 4);
}

function MSU_Base64ThumbnailError($inMessage) {
	// echo ($inMessage."\n");
	return null;
}

function MSU_Base64Thumbnail($inID) {
	// get the attachment src
	$tmp = wp_get_attachment_image_src($inID, "Super Tiny");

	// bail if there's no super tiny version
	if (!$tmp[3]) return null;

	// try to get the file contents
	$tmp[0] = preg_replace("/^.*\\/wp-content/i", "/wp-content", $tmp[0]);
	$tmp[0] = $_SERVER["DOCUMENT_ROOT"].$tmp[0];

	$contents = file_get_contents($tmp[0]);
	if (!$contents) return null;

	// create data URI
	$dataURI = "data:image/jpeg;base64,".base64_encode($contents);

	return $dataURI;
}

/*
function MSU_Base64Thumbnail($inFilename) {
	// define variables
	$imageInfo = null;
	$originalWidth = 0;
	$originalHeight = 0;
	$newWidth = 0;
	$newHeight = 0;
	$originalImage = null;
	$newImage = null;

	// confirm the file exists
	if (!file_exists($inFilename)) return MSU_Base64ThumbnailError("File ".$inFilename." does not exist.");

	// see if there's a cached base64 file
	if (file_exists($inFilename.".base64.txt")) {
		return file_get_contents($inFilename.".base64.txt");
	}

	// confirm that the file is an image
	$imageInfo = getimagesize($inFilename);
	if ($imageInfo === false) return MSU_Base64ThumbnailError("File ".$inFilename." is not an image.");

	// open the file as an image
	if ($imageInfo["mime"] == "image/jpeg") {
		$originalImage = imagecreatefromjpeg($inFilename);
	} else {
		return MSU_Base64ThumbnailError("Unrecognized type: ".$imageInfo["mime"]);
	}
	if (!$originalImage) return MSU_Base64ThumbnailError("Unable to open image ".$inFilename);

	// find the new size 
	$originalWidth = imagesx($originalImage);
	$originalHeight = imagesy($originalImage);
	if ($originalWidth == 0 || $originalHeight == 0) return null;

	if ($originalWidth>$originalHeight) {
		$newWidth = BASE64_IMAGE_MAX_RES;
		$newHeight = max(array(1, round($originalHeight * $newWidth/$originalWidth)));
	} else {
		$newHeight = BASE64_IMAGE_MAX_RES;
		$newWidth = max(array(1, round($originalWidth * $newHeight/$originalHeight)));
	}

	// resize image 
	$newImage = imagecreatetruecolor($newWidth, $newHeight);
	if (!$newImage) return null;
	imagecopyresampled($newImage, $originalImage, 0, 0, 0, 0, $newWidth, $newHeight, $originalWidth, $originalHeight);
	imagedestroy($originalImage);

	// compress image as JPEG
	ob_start();
	$imageData = imagegif($newImage, null);
	$imageData = ob_get_contents();
	ob_end_clean();
	imagedestroy($newImage);

	// create data URI
	$dataURI = "data:image/gif;base64,".base64_encode($imageData);

	// cache and save
	file_put_contents($inFilename.".base64.txt", $dataURI);
	return $dataURI;
}
*/
