$(document.body).ready(function () {

	var tmp = document.location.pathname.toString();
	if ("console" in window) console.log("Error Page Pathname: "+tmp);
	tmp = tmp.toLowerCase();
	tmp = tmp.replace(/[^0-9a-z]/gi, " ");
	tmp = tmp.replace(/[\s]+/g, " ");
	tmp = tmp.replace(/^\s/, "");
	tmp = tmp.replace(/\s$/, "");
	if ("console" in window)console.log("Extracted Search Query: "+tmp);
	
	var args = {
		"q": tmp,
		"loose": "true",
		"filter": "page,department,academic",
		"action": "search"
	};
	
	var url = "//www.montclair.edu/hawkeye/data.php?callback=?";
	
	var makeTag = function (tagName, className, text) {
		if (tagName == null) {
			return document.createTextNode(text);
		} else {
			var el = document.createElement(tagName.toUpperCase());
			if (className) el.className = className;
			if (text) el.appendChild(makeTag(null, null, text));
			return el;
		}
	}
	
	$.getJSON(url, args, function (data) {
		if (data.status == "success") {
			console.log(data.data);
			var out = $(".live-search-output").get(0);
			if (data.data.length > 0) {
				out.appendChild(makeTag("p", null, "We were able to find the following pages that match all or some of the URL you requested:"));
				/*
				for (var i=0; i<data.data.pages.length; i++) {
					var p = data.data.pages[i];
					
					var a = makeTag("a", "live-search-result", null);
					a.href = p.url;
					
					a.appendChild(makeTag("span", "title", p.name));
					a.appendChild(makeTag("span", "url", p.url));
					
					out.appendChild(a);
				}
				*/
				var sidebarSearch = makeTag("div", "sidebar-search");
				var results = makeTag("div", "results");
				for (var i=0; i<data.data.length;i++) {
					results.innerHTML += data.data[i].html;
				}
				sidebarSearch.appendChild(results);
				out.appendChild(sidebarSearch);
				ensureCSS(window.themeRoot+"/search-icons.css");
			} else {
				out.appendChild(makeTag("p", null, "We checked our most popular pages using words from the URL you requested, but didn't find any matches."));
			}
		} else {
			if ("console" in window) console.log(data.message);
		}
	});

});
