<?PHP 

if (!function_exists("get_header")) exit("Wordpress not loaded.");
$isMainSite = !is_multisite() || (network_home_url() == home_url()."/")?true:false; 

?>
		<footer class="page-footer" aria-label="Page Footer">
			<div class="college-hall-holder"><svg viewbox="0 0 256 256" alt=""><use xlink:href="#college-hall-footer" /></svg></div>
			<div class="site-identification">
				<div class="logo-holder">
					<div class="msu-logo"><div><a href="/" aria-label="Montclair State University"><span class="a11y-label">Montclair State University</span><svg viewbox="0 0 225 45"><use xlink:href="#msu-logo-2023" /></svg></a></div></div>
				</div>
				<ul class="address-links">
					<li><a href="https://www.montclair.edu/about-montclair/directions/" class="address"><span class="a11y-label">Address: 1 Normal Avenue, Montclair, New Jersey 0 7 0 4 3</span><span aria-hidden="true"><svg viewbox="0 0 30 30"><use xlink:href="#map-pin" /></svg> 1 Normal Ave.<br />Montclair, NJ 07043</span></a></li>
					<li><a href="tel:9736554000" class="phone a11y-phone-number initialized"><svg viewbox="0 0 30 30"><use xlink:href="#smartphone" /></svg><span class="a11y-label">Phone Number:</span><span>973-655-4000</span></a></li>
					<li><a href="https://www.montclair.edu/campus-map/" class="map"><svg viewbox="0 0 30 30"><use xlink:href="#campus-map" /></svg>Campus Map</a></li>
				</ul>
				<ul class="social-links">
					<li><a href="https://twitter.com/montclairstateu" class="twitter" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#x-twitter" /></svg>University Twitter</a></li>
					<li><a href="https://www.facebook.com/MontclairStateUniversity" class="facebook" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#facebook" /></svg>University Facebook</a></li>
					<li><a href="https://www.instagram.com/montclairstateu/" class="instagram" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#instagram-new" /></svg>University Instagram</a></li>
					<li><a href="https://www.youtube.com/@montclairstateu" class="youtube" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#youtube" /></svg>University YouTube</a></li>
					<li><a href="https://www.tiktok.com/@montclairstateu" class="tik-tok" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#tik-tok" /></svg>University TikTok</a></li>
				</ul>
			</div>
			<div class="footer-menu">
				<?PHP 
					if (!$isMainSite) {
						$FooterMenuLabel = get_option("FooterMenuLabel");
						if (!isset($FooterMenuLabel) || empty($FooterMenuLabel)) {
							$FooterMenuLabel = get_bloginfo("title");
						} else {
							$FooterMenuLabel = htmlspecialchars($FooterMenuLabel, ENT_COMPAT|ENT_QUOTES, 'UTF-8');
						}
						?>
						<div class="column">
							<p><a href="<?PHP bloginfo("url");?>/"><?PHP echo $FooterMenuLabel;?></a></p>
							<?PHP wp_nav_menu(array("depth"=>1)); ?>
						</div>
						<?PHP	
					}
				?>
				<div class="column">
					<p><a href="https://www.montclair.edu/">Montclair State<span class="a11y-label"> University</span></a></p>
					<?PHP
						// Get the header menu for the network site
						$useDefaultMenu = false;
						if (is_multisite()) {
							switch_to_blog(1);
							$FooterMenuName = "Header Menu";
							if (wp_get_nav_menu_object($FooterMenuName) && false) {
								$useDefaultMenu = false;
							}
						}
						if (!$useDefaultMenu) {
							// if it exists, output the menu here
							wp_nav_menu(array("menu"=>$FooterMenuName,"depth"=>1));
						} else {
							// if it doesn't exist, output a placeholder
							?>
							<ul>
								<li><a href="https://www.montclair.edu/about-montclair/">About Montclair</a></li>
								<li><a href="https://www.montclair.edu/academics/">Academics</a></li>
								<li><a href="https://www.montclair.edu/university-admissions/">Admissions</a></li>
								<li><a href="https://www.montclair.edu/arts-and-culture/">Arts &amp; Culture</a></li>
								<li><a href="https://www.montclairathletics.com/">Athletics</a></li>
								<li><a href="https://www.montclair.edu/campus-life/">Campus Life</a></li>
								<li><a href="https://www.montclair.edu/research/">Research</a></li>
								<!-- This is the default menu -->
							</ul>
							<?PHP 
						}
						// switch back to the current site
						if (is_multisite()) restore_current_blog();
					?>
				</div>
				<?PHP if (file_exists(dirname(__FILE__)."/footer-policies.php")) { 
					echo "<div class=\"column\">\n";
					include(dirname(__FILE__)."/footer-policies.php");
					echo "</div>\n";
				}
				?>
			</div>
			<p class="return-to-top"><a href="#content-start"><svg viewBox="0 0 30 30" alt="Return to top"><use xlink:href="#return-to-top-arrow" /></svg></a><span class="label">Return to Top</span></p>
		</footer>
		
		<script type="text/javascript">
			// ensureCSS("main.css");
		</script>
		<?PHP 
		wp_footer();
		echo (get_option("AdvertiserTargeting")); 
		// include_once(dirname(__FILE__)."/standard-retargeting-pixels.php");
		?>
	</body>
</html>