<?PHP

if (!defined("ENT_HTML5")) {
	define("ENT_HTML5", 0);
}

require_once(dirname(__FILE__)."/options.php");
require_once(dirname(__FILE__)."/meta-box.php");
require_once(dirname(__FILE__)."/roles.php");

// return user's current Do Not Track setting
function dnt_user() {
	return ((isset($_SERVER['HTTP_DNT']) && $_SERVER['HTTP_DNT'] == 1 ) || isset($_GET['DNT']) && $_GET['DNT'] == 1);
}

// allow 3 character user names (because our NetID system allows that)
function wpse_59760_short_user_names( $result )
{
	// get all of the errors related to the username
	$error_name = $result[ 'errors' ]->get_error_message( 'user_name' );
	// if the username has errors APART FROM the length restriction, let's keep all the errors
	if (empty($error_name) || ($error_name !== __('Username must be at least 4 characters.'))) {
		return $result;
	}

	// unset the error message
	unset ( $result[ 'errors' ]->errors[ 'user_name' ] );

	// check the username against the character limit we actually want
	if (mb_strlen($result["user_name"])<3) {
		$result["errors"]->add("user_name", "Username must be at least 3 characters.");
	}

	return $result;
}
add_filter( 'wpmu_validate_user_signup', 'wpse_59760_short_user_names' );

// Allow Aria label
function my_format_TinyMCE( $in ) {
	$in["extended_valid_elements"] = 
		"a[rel|rev|charset|hreflang|tabindex|accesskey|type|name|href|target|title|class|onfocus|onblur|aria-label|id]".
		",img[longdesc|usemap|src|border|alt=|title|hspace|vspace|width|height|align|aria-label],-h1[aria-label|id]".
		",-h2[aria-label|id],-h3[aria-label|id],-h4[aria-label],-h5[aria-label],-h6[aria-label]".
		",th[scope|rowspan|colspan|class|data*]".
		",video[title|aria-label|width|height|autoplay|loop|playsinline|muted|onclick|class]".
		",source[src|type|codecs]";
	return $in;
}
add_filter( 'tiny_mce_before_init', 'my_format_TinyMCE' );

function mawaha_filter_allowed_html($allowed, $context) {
 
	if (is_array($context)) {
		return $allowed;
	}
 
	if ($context === 'post' || $context === 'page') {
		$allowed['th']['data-column-type'] = true;
		$allowed['video']['playsinline'] = true;
		$allowed['video']['onclick'] = true;
		if (!isset($allowed['source']) || !is_array($allowed['source'])) {
			$allowed['source'] = array();
		}
		$allowed['source']['src'] = true;
		$allowed['source']['type'] = true;
		$allowed['source']['codecs'] = true;
	}
 
	return $allowed;
}
add_filter('wp_kses_allowed_html', 'mawaha_filter_allowed_html', 10, 2);

function pwcc_jquery_to_footer( &$wp_scripts ) {
	if ( is_admin() ) {
		return;
	}
	
	/* 
	Move jQuery to the HTML footer 
	This should be fine but may cause problems with some plugins as it potentially breaks backward compatibility. Well coded plugins should be good.

	doing_it_wrong_and_loving_it
	*/
	$wp_scripts->add_data( 'jquery',         'group', 1 ); 
	$wp_scripts->add_data( 'jquery-core',    'group', 1 ); 
	$wp_scripts->add_data( 'jquery-migrate', 'group', 1 ); 
}
add_action( 'wp_default_scripts', 'pwcc_jquery_to_footer' );

function OutputHeaderNewsFeed() {
	$cached = get_site_transient("msu_header_news");
	if ($cached) {
		echo ($cached);
		echo ("<!-- * -->");
		return true;
	} else {
		switch_to_blog(15); // 7 on localhost (news import test), 15 on production (newscenter)

		$args = array(
			'posts_per_page'   => 3,
			'offset'           => 0,
			'category'         => '',
			'category_name'    => '', // use full name if you want to set this (e.g. "Press Releases")
			'orderby'          => 'date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'post',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	   => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$posts_array = get_posts( $args );

		if (!is_array($posts_array)) {
			echo ("<p>Unable to load posts.</p>");
			restore_current_blog();
			return false;
		} else if (count($posts_array)==0) {
			echo ("<p>No articles published.</p>");
			restore_current_blog();
			return false;
		}

		$outstr = "";
		foreach ($posts_array as $p) {
			$outstr .= sprintf("<a href='%s' class='article'>", get_permalink($p));
			$outstr .= sprintf("<span class='headline'>%s</span>", $p->post_title);
			if (isset($p->post_excerpt) && !empty($p->post_excerpt)) {
				$outstr .= sprintf("<span class='lead'>%s</span>", $p->post_excerpt);
			}
			$outstr .= "</a>";
		}

		set_site_transient("msu_header_news", $outstr, 5*60); // transient good for 5 minutes
		echo ($outstr);

		restore_current_blog();
		return true;
	}
}

if (!function_exists ( "mpEnqueueScripts")) {
	function mpEnqueueScripts() {
		wp_register_script("prpl-main", get_template_directory_uri()."/main.js", array("jquery-core"), filemtime( get_template_directory() . '/main.js' ), true);
		wp_register_script("error-page-live-search", get_template_directory_uri()."/error-page-live-search.js", array("jquery-core"), "1.0", true);
		wp_register_script("owl-carousel", get_template_directory_uri()."/owl-carousel/owl.carousel.min.js", array("jquery-core"), "1.0", true);
		wp_register_script("gdpr-detect", "https://www.montclair.edu/gdpr-script/gdpr-module.js", null, "1.1", true);
		wp_register_script("enyo",get_template_directory_uri()."/enyo/current/enyo/enyo.js", array(), "1.0", false);
		wp_register_script("gpa-calc", get_template_directory_uri()."/gpa-calc.js", array("enyo"), "1.0", false);


		wp_register_style("owl-carousel", get_template_directory_uri()."/owl-carousel/owl.carousel.min.css", null, "1.0");
		wp_register_style("homepage-hawkeye-icons", get_template_directory_uri()."/search-icons.css", null, "1.0");
		wp_register_style("gpa-calc", get_template_directory_uri()."/gpa-calc.css", null, "1.0");
		wp_enqueue_style( 'msu-style', get_template_directory_uri()."/style.css", false, filemtime( get_template_directory() . '/style.css' ) );
		if (get_stylesheet_directory() != get_template_directory()) {
			wp_enqueue_style( 'msu-child-style', get_stylesheet_directory_uri()."/style.css", false, filemtime( get_stylesheet_directory() . '/style.css' ) );
		}
		wp_enqueue_script("prpl-main");
		if ($_SERVER["HTTP_HOST"] == "www.montclair.edu") {
			wp_enqueue_script("gdpr-detect");
		}
	}

	add_action("wp_enqueue_scripts", "mpEnqueueScripts");
}

/* *************** */
/* ADD THUMBNAILS TO RSS FEEDS */
add_action('rss2_item', 'add_my_rss_node');
add_action('rss_item', 'add_my_rss_node');
function add_my_rss_node() {
	global $post;
	if(has_post_thumbnail($post->ID)) {
		// $thumbnail = get_attachment_link(get_post_thumbnail_id($post->ID));
		$thumbnail = get_the_post_thumbnail_url($post->ID, "medium");
		echo("<image>{$thumbnail}</image>");
	}
}
/* *************** */

// ADD SUPPORT FOR EPS FILES
function my_myme_types($mime_types){
    $mime_types['eps'] = 'application/postscript'; //Adding svg extension
    return $mime_types;
}
add_filter('upload_mimes', 'my_myme_types', 1, 1);


// ADD CACHE CONTROL HEADER
add_action( "send_headers", "MSU_AddCacheHeader");
function MSU_AddCacheHeader () {
	// if the user session timed out ...
	if(isset($_GET["wp_logged_in"]) && !is_user_logged_in()) {
		// no matter what we don't want to cache this page
		header("Cache-Control: no-cache, must-revalidate, max-age=0");
		// get the current URL
		$current_url = home_url();
		// find the key for the cookie that generated the "wp_logged_in" querystring
		$key = "";
		foreach ($_COOKIE as $k=>$v) {
			if (mb_stripos($k, "wordpress_logged_in")===0) {
				$key = $k;
			}
		}
		// if we found a key ...
		if (isset($_COOKIE[$key])) {
			// clear the cookie
			unset($_COOKIE[$key]); 
			setcookie($key, null, -1, '/'); 
			// redirect to this page but with no querystring
			header("Location: ".$current_url);
			exit();
		}
	}
	if (is_user_logged_in() || (isset($_SERVER["HTTP_USER_AGENT"]) && mb_stripos($_SERVER["HTTP_USER_AGENT"], "by SiteImprove.com")!==false)) {
		header("Cache-Control: no-cache, must-revalidate, max-age=0");
	} else {
		header("Cache-Control: max-age=".(60*15).", must-revalidate");
		header("Vary: Accept-Encoding,User-Agent,DNT"); // vary cache on DNT flag
	}
}

// GET IMAGE SITE ID FROM URL
function mpGetImageSiteIDFromURL($inURL) {
	if (!$inURL) return false;
	$matches = array();
	preg_match("/sites\/([0-9]+)/", $inURL, $matches);
	if (count($matches)==2) {
		return intval($matches[1]);
	} else {
		return false;
	}
}

// GET IMAGE ID FROM URL
function mpGetIDFromURL($url) {
	global $wpdb;

	// Ignore protocol and only match on the ending part of the URL using MySQL LIKE
	$url = preg_replace("/^http[s]?/i", "", $url);

	// first see if somebody uploaded a file with ###x### at the end
	$myQuery = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid LIKE %s", "%".$wpdb->esc_like($url)));

	// if we found an original file with that pattern return it (usually super-small photos)
	if (isset($myQuery->ID)) return $myQuery->ID;

	// now strip off the width/height at the end and see if we can find the original filename
	$fname = preg_replace('/-[0-9]+x[0-9]+.([a-z]+)$/i', ".$1", $url);

	// $myQuery = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid=%s", $fname));
	$myQuery = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid LIKE %s", "%".$wpdb->esc_like($fname)));
	if (isset($myQuery->ID)) return $myQuery->ID;

	// what about if it's doing that new dumb thing with -scaled?
	$fname_not_scaled = str_replace("-scaled.", ".", $fname);
	$myQuery = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid LIKE %s", "%".$wpdb->esc_like($fname_not_scaled)));
	if (isset($myQuery->ID)) return $myQuery->ID;

	// last chance - strip off id that may have been added when we resized the image inside wordpress
	$fname = preg_replace('/-e[0-9]+\.(jpg|png|gif)$/i',".$1", $fname);
	$myQuery = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid LIKE %s", "%".$wpdb->esc_like($fname)));

	return isset($myQuery->ID)?$myQuery->ID:null;
}

function mpGetImageTag($id, $size) {
	$tmp = wp_get_attachment_image_src($id, $size);
	if (is_array($tmp)) {
		return "<img src=\"".$tmp[0]."\" width=\"".$tmp[1]."\" height=\"".$tmp[2]."\" />";
	} else {
		return "";
	}
}

function ad_update_jpeg_quality($meta_id, $attach_id, $meta_key, $attach_meta) {

	if ($meta_key == '_wp_attachment_metadata') {

		$post = get_post($attach_id);

		if ($post->post_mime_type == 'image/jpeg' && is_array($attach_meta['sizes'])) {

			$pathinfo = pathinfo($attach_meta['file']);
			$uploads = wp_upload_dir();
			$dir = $uploads['basedir'] . '/' . $pathinfo['dirname'];

			foreach ($attach_meta['sizes'] as $size => $value) {

				$image = $dir . '/' . $value['file'];
				$resource = imagecreatefromjpeg($image);

				if (substr($size, -2)=="2x") {
					imagejpeg($resource, $image, 65);
				} else {
					imagejpeg($resource, $image, 85);
				}

				// or you can skip a paticular image size
				// and set the quality for the rest:
				// if ($size == 'splash') continue;

				imagedestroy($resource);
			}
		}
	}
}

/*
function MSU_CreateMenuBlades() {
	register_post_type("msu_menu_blade",
		array(
			"labels" => array(
				"name" => "Menu Panels",
				"singular_name" => "Menu Panel"
			),
			"public" => true,
			"has_archive" => false,
			"rewrite" => array(
				"slug" => "menupanels"
			),
			"show_ui" => true
		)
	);
}

add_action("init", "MSU_CreateMenuBlades");
*/

function MSU_RegisterQuicklinksMenu() {
	if (function_exists('register_nav_menus')) {
		register_nav_menus (
		array('quicklinks_nav' => 'Quicklinks'));
	}
}

add_action("init", "MSU_RegisterQuicklinksMenu");




if (!function_exists("custom_theme_setup")) {
	function custom_theme_setup() {
		// This theme styles the visual editor with editor-style.css to match the theme style.
		add_editor_style();
		
		// This theme uses post thumbnails
		add_theme_support( 'post-thumbnails' );

		// This theme supports excerpts in pages (for open graph description)
		add_post_type_support( 'page', 'excerpt' );

		/*
		add_image_size("Listing Mobile 1x", 240, 135, true);
		add_image_size("Listing Mobile 2x", 480, 270, true);
		add_image_size("Listing Tablet 1x", 282, 159, true);
		add_image_size("Listing Tablet 2x", 564, 318, true);
		add_image_size("Listing Desktop 1x", 352, 198, true);
		add_image_size("Listing Desktop 2x", 704, 397, true);
		// add_image_size("Listing Huge 1x", 528, 297, true);
		// add_image_size("Listing Huge 2x", 1056, 596, true);

		add_image_size("Hero Mobile 1x", 480, 270, true);
		add_image_size("Hero Mobile 2x", 960, 540, true);
		add_image_size("Hero Tablet 1x", 784, 441, true);
		add_image_size("Hero Tablet 2x", 1568, 882, true);
		add_image_size("Hero Desktop 1x", 980, 551, true);
		add_image_size("Hero Desktop 2x", 1960, 1102, true);
		// add_image_size("Hero Huge 1x", 1470, 827, true);
		// add_image_size("Hero Huge 2x", 2940, 1654, true);

		add_image_size("Caption Mobile 1x", 448, 252, true);
		add_image_size("Caption Mobile 2x", 896, 504, true);
		add_image_size("Caption Tablet 1x", 624, 351, true);
		add_image_size("Caption Tablet 2x", 1248, 702, true);
		add_image_size("Caption Desktop 1x", 780, 439, true);
		add_image_size("Caption Desktop 2x", 1560, 878, true);
		*/

		set_post_thumbnail_size(240, 135, true);
		add_image_size("Super Tiny", 32, 32, false);

		/* menus */
		register_nav_menus( array(
			'primary' => 'Primary Menu',
			'footer' => 'Footer Menu'
		) );


		/* disable formidable dropzone */
		add_filter( 'frm_load_dropzone', '__return_false' );

		// Disable XMLRPC
		add_filter("xmlrpc_enabled", "__return_false");
		add_filter("wp_headers", function ($headers) {
			unset($headers["X-Pingback"]);
			return $headers;
		});
		remove_action("wp_head", "wlwmanifest_link");
		remove_action("wp_head", "rsd_link");
	}
}
add_action( 'after_setup_theme', 'custom_theme_setup' );

// The rendered header menu HTML is stored in a transient variable that lasts for 24 hours.
// When a user publishes or updates a post of type "msu_menu_blade" the transient variable is
// cleared so that it will be re-rendered the next time.
if (!function_exists("msuInvalidateHeaderMenu")) {
	function msuInvalidateHeaderMenu() {
		delete_transient("RenderedTopMenu");
	}
	
	function msuTopMenuPublish($inID, $inPost) {
		if ($inPost->post_type == "msu_menu_blade") {
			msuInvalidateHeaderMenu();
		}
	}
	
	function msuTopMenuUpdate($inID, $inPostAfter, $inPostBefore) {
		if ($inPostAfter->post_type == "msu_menu_blade") {
			msuInvalidateHeaderMenu(); 
		}
	}
	
	add_action("publish_post", "msuTopMenuPublish", 10, 2);
	add_action("post_updated", "msuTopMenuUpdate", 10, 3);
}



function MSU_CollectChildren($menuItems) {
	$parentsArray = array();
	
	foreach($menuItems as $m) {
		/*
		$tmp = null;
		$tmp->ID = $m->ID;
		$tmp->menu_item_parent = $m->menu_item_parent;
		$tmp->title = $m->title;
		*/
		$tmp = $m;
		if (!isset($parentsArray[$tmp->menu_item_parent])) {
			$parentsArray[$tmp->menu_item_parent] = array();
		}
		$parentsArray[$tmp->menu_item_parent] []=$tmp;
	}
	
	$outputArray = array();
	foreach ($menuItems as $m) {
		if (isset($parentsArray[$m->ID])) {
			$m->children = $parentsArray[$m->ID];
		}
		$outputArray[$m->ID] = $m;
	}
	
	return $outputArray;
}

function MSU_BuildLeftMenu($tree, $pageID, $includeTopLevel=false, $post_type=null) {
	$retVal = "";
	$menuID = null;

	// sanity check 
	if (!is_array($tree)) return "";

	// If we want to include the top level, the easiest way to do that with our
	// already-written code is to add the top level page as an object in our menu,
	// then make that the new parent node for everything that has 0.
	if ($includeTopLevel) {
		$topLevelObject = new stdClass();
		$topLevelObject->object_id = get_option('page_on_front');
		$topLevelObject->ID = 0;
		foreach($tree as $page) {
			if ($page->ID > $topLevelObject->ID) $topLevelObject->ID = $page->ID;
		}
		$topLevelObject->ID++;
		$topLevelObject->url = get_bloginfo('url');
		$topLevelObject->title = get_bloginfo('title');
		$topLevelObject->menu_item_parent = 0;
		$topLevelObject->children = array();
		foreach($tree as $i => $val) {
			if ($tree[$i]->menu_item_parent == 0) {
				$tree[$i]->menu_item_parent = $topLevelObject->ID;
				$topLevelObject->children[]=$tree[$i];
			}
		}
		$tree[]=$topLevelObject;
	}
	
	// find this page in the tree
	foreach($tree as $page) {
		if ((isset($page->object_id) && $page->object_id == $pageID) && 
			(empty($post_type) || (isset($page->object) && $post_type == $page->object))) {
			$menuID = $page->ID;
			// echo sprintf("<!-- post_type = %s -->", $post_type);
		}
	}

	// if this page isn't in the tree, bail
	if ($menuID == null) return null;
	
	// assign our starting values
	$page = $tree[$menuID];
	$parentID = $page->menu_item_parent;

	// if our page is at the top level ...
	if ($parentID == 0) {
		// display all children of this page
		$retVal .= "<ul>";
		if (isset($page->children)) foreach ($page->children as $child) {
			$retVal .= "<li><a href=\"".$child->url."\" target=\"".$child->target."\">".$child->title."</a></li>";
		}
		$retVal .= "</ul>";
	// if our page isn't at the top level
	} else {
		// First build the children
		$childrenHTML = "";
		if (isset($page->children)) {
			$childrenHTML .= "<ul>";
			foreach ($page->children as $child) {
				$childrenHTML .= "<li><a href=\"".$child->url."\">".$child->title."</a></li>";
			}
			$childrenHTML .= "</ul>";
		}
		
		// Start a while loop that will iterate through our page's acestors
		while ($parentID != 0) {
			// output the siblings of the current page
			$siblingHTML = "";
			$parent = $tree[$parentID];
			$siblingHTML .= "<ul>";
			foreach ($parent->children as $sibling) {
				// If it's the current page, put the HTML for the child pages in here. Otherwise, we don't display a sibling's children.
				$isCurrent = ($sibling->ID == $menuID);
				$siblingHTML .= "<li class=\"".($isCurrent?"current-page":"")."\"><a href=\"".$sibling->url."\">".$sibling->title."</a>";
				if ($isCurrent) {
					$siblingHTML .= $childrenHTML;
				}
				$siblingHTML .= "</li>";
			}
			$siblingHTML .= "</ul>";
			
			// move up to parent node
			$menuID = $parentID;
			$parentID = $parent->menu_item_parent;
			$childrenHTML = $siblingHTML;
		}
		
		$retVal = $childrenHTML;
		$page = $parent;
	}
	
	if ($page->url[strlen($page->url)-1] != "/") {
		$page->url .= "/";
	}
	$retVal = "<p><a href=\"".$page->url."\">".$page->title."</a></p>".$retVal;
	
	return $retVal;	
}

if (!function_exists("wp_strtotime")) {
	function wp_strtotime($str) {
		// This function behaves a bit like PHP's StrToTime() function, but taking into account the Wordpress site's timezone
		// CAUTION: It will throw an exception when it receives invalid input - please catch it accordingly
		// From https://mediarealm.com.au/

		$tz_string = get_option('timezone_string');
		$tz_offset = get_option('gmt_offset', 0);

		if (!empty($tz_string)) {
			// If site timezone option string exists, use it
			$timezone = $tz_string;

		} elseif ($tz_offset == 0) {
			// get UTC offset, if it isn’t set then return UTC
			$timezone = 'UTC';

		} else {
			$timezone = $tz_offset;
			
			if(substr($tz_offset, 0, 1) != "-" && substr($tz_offset, 0, 1) != "+" && substr($tz_offset, 0, 1) != "U") {
				$timezone = "+" . $tz_offset;
			}
		}

		$datetime = new DateTime($str, new DateTimeZone($timezone));
		return $datetime->format('U');
	}
}

if (!function_exists("msu_disable_author_pages")) {
	function msu_disable_author_pages() {
		global $wp_query;

		if ( is_author() ) {
			wp_redirect(get_option("home"), 301);
			exit;
		}
	}
	add_action("template_redirect", "msu_disable_author_pages");
}

// revisionary fix
add_filter('rvy_hidden_meta_boxes', 'revisor_show_featured_image_box');

function revisor_show_featured_image_box($unrevisable_css_ids) {
	$key = array_search('postimagediv', $unrevisable_css_ids, true);
	unset($unrevisable_css_ids[$key]);

	return $unrevisable_css_ids;
}

// fix for maximum image size (no more limiting to 2560 pixels)
add_filter( 'big_image_size_threshold', '__return_false' );

require_once(dirname(__FILE__)."/shortcodes.php");
require_once(dirname(__FILE__)."/gutenberg-config.php");
require_once(dirname(__FILE__)."/oembed-titles.php");

?>