/**
 * Define a single row of the GPA calculator
 */

enyo.kind({
	name: "GPACalcRow",
	classes: "gpa-calc-row",
	credits: null,
	grade: null,
	qualityPoints: null,
	gradeTable: {
		"a+": 4, "a": 4, "a-": 3.7,
		"b+": 3.3, "b": 3, "b-": 2.7,
		"c+": 2.3, "c": 2, "c-": 1.7,
		"d+": 1.3, "d": 1, "d-": 0.7,
		"f+": 0, "f": 0, "f-": 0
	},
	
	components: [
		{tag: "label", classes: "one-third", components: [
			{tag: "span", content: "Credits: "},
			{kind: "Input", name: "Credits", value: "", oninput: "reCalc"}
		]},
		{tag: "label", classes: "one-third", components: [
			{tag: "span", content: "Grade: "},
			{kind: "Input", name: "Grade", value: "", oninput: "reCalc"}
		]},
		{tag: "span", classes: "one-third", components: [
			{tag: "span", content: "Quality Points: "},
			{tag: "span", name: "QualityPoints"}
		]} 
	],
	
	reCalc: function() {
		// try to convert the letter grade to a value
		if (this.$.Grade.getValue().toLowerCase() in this.gradeTable) {
			this.grade = this.gradeTable[this.$.Grade.getValue().toLowerCase()];
		} else {
			this.grade = null;
		}

		// convert credits input into a number
		this.credits = parseFloat(this.$.Credits.getValue(), 10);
		if (isNaN(this.credits)) this.credits=null;

		// if we have a valid number of credits and a valid grade
		if (this.grade!==null && this.credits!==null) {
			// calculate the quality points for this row
			this.qualityPoints = this.credits*this.grade;
			this.$.QualityPoints.setContent(this.qualityPoints.toFixed(2));
		} else {
			// for invalid inputs, quality points should be blank (not 0)
			this.qualityPoints=null;
			this.$.QualityPoints.setContent("");
		}

		// refresh the calculator
		this.owner.reCalc();
	},
	
	// selector functions - safely gives parent access to data
	getCredits: function () { return this.credits; },
	getGrade: function () {return this.grade; },
	getQualityPoints: function () {return this.qualityPoints; },
	
	// startup routine
	rendered: function () {
		// enyo bookkeeping
		this.inherited(arguments);
		// handles case of back button (form already filled in)
		this.reCalc(); 
	}
});


/**
 * Generate a calculator using multiple rows
 */

enyo.kind({
	name: "GPACalc",
	classes: "gpa-calc",
	
	components: [
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{kind: "GPACalcRow"},
		{tag: "div", classes: "gpa-total-divider", content: "Total:"},
		{tag: "div", classes: "gpa-calc-row", components: [
			{tag: "span", classes: "one-third", components: [
				{tag: "span", content: "Credits: "},
				{name: "Credits", tag: "span", content: ""}
			]},
			{tag: "span", classes: "one-third", components: [
				{tag: "span", content: "GPA: "},
				{name: "GPA", tag: "span", content: ""}
			]},
			{tag: "span", classes: "one-third", components: [
				{tag: "span", content: "Quality Points: "},
				{name: "QualityPoints", tag: "span", content: ""}
			]}
		]}
	],
	
	reCalc: function () {
		var sum = {credits: 0, qualityPoints: 0};
		// iterate through child components
		var c = this.getComponents();
		for (var i=0;i<c.length;i++) {
			// for each GPACalcRow that has quality points
			if (c[i].kind == "GPACalcRow" && c[i].getQualityPoints()!==null) {
				// add to the sum
				sum.credits += c[i].getCredits();
				sum.qualityPoints += c[i].getQualityPoints();
			}
		}
		// debug output the sum
		enyo.log(sum);

		// if there were valid entries
		if (sum.credits > 0) {
			// calculate values and display output
			this.$.Credits.setContent(sum.credits);
			this.$.QualityPoints.setContent(sum.qualityPoints.toFixed(2));
			this.$.GPA.setContent((sum.qualityPoints/sum.credits).toFixed(2));
		} else {
			// clear output areas
			this.$.Credits.setContent("");
			this.$.QualityPoints.setContent("");
			this.$.GPA.setContent("");
		}
	},
	
	// startup routine
	create: function () {
		// enyo bookkeeping
		this.inherited(arguments);
	}
});

(new GPACalc).renderInto(document.getElementById("GPACalculator"));