<?PHP 
/*
// This was some sample code that is no longer in use. Keeping around in a comment
// so I can refer back to it later. DO NOT UNCOMMENT
// ??= is not supported in the current version of PHP on www-dev or www
function MSU_custom_render_core_blocks (string $block_content, array $block): string {
	if (
		$block['blockName'] === 'core/image' && 
		!is_admin() &&
		!wp_is_json_request()
	) {
		$html = '';

		$block['attrs']['className'] ??= '';

		// Add background color to the page section
		$block['attrs']['className'] .= ' theme--' . ($block['attrs']['backgroundColor'] ?? 'white');

		$html .= '<div class="group ' . $block['attrs']['className'] . '">' . "\n";
		$html .= '<div class="container">' . "\n";

		if (isset($block['innerBlocks'])) {
			foreach ($block['innerBlocks'] as $inner_block) {
				$html .= render_block($inner_block);
			}
		}

		$html .= '</div><!--/ .container -->' . "\n";
		$html .= '</div><!--/ .group -->' . "\n";

		return $html;
	}

	return $block_content;
}

add_filter('render_block', 'MSU_custom_render_core_blocks', null, 2);

*/


function MSU_allowed_block_types() {
	return array(
		'core/heading',		// Heading block
		'core/paragraph',	// Paragraph Block
		'core/list',		// UL and OL
		'core/quote',		// blockquotes
		'core/preformatted',// PRE tag
		'core/table',		// TABLE tag
		'core/freeform',	// Classic Editor Block
		'core/image',		// Image Block
		'core/audio',		// Audio
		'core/video',		// Video
		'core/separator',	// HR tag
		'core/embed',		// every fucking embed tag under the sun (see below for limits on embeds)
	);
}
// add_filter( 'allowed_block_types', 'MSU_allowed_block_types' );
add_filter('allowed_block_types_all', 'MSU_allowed_block_types');

function MSU_limit_embed_types_script() {
    wp_enqueue_script(
        'deny-list-blocks',
        get_template_directory_uri() . '/gutenberg-disable-embed-variations.js',
        array( 'wp-blocks', 'wp-dom-ready', 'wp-edit-post' )
    );
}
add_action( 'enqueue_block_editor_assets', 'MSU_limit_embed_types_script' );

function MSU_CustomImageOutput($block_content, $block) {
	$matches = array();


	$ImageID = $block["attrs"]["id"];
	$ImageURL = wp_get_attachment_image_src($ImageID, "full");
	$ImageURL = $ImageURL[0];

	if (!$ImageURL) return "";

	$ImageTag = "";
	if (preg_match("/svg\$/i", $ImageURL)) {
		$ImageTag = wp_get_attachment_image($ImageID, "full");
	} else if (preg_match("/gif\$/i", $ImageURL)) {
		$ImageTag = wp_get_attachment_image($ImageID, "full");
	} else {
		$ImageTag = getResponsiveImageTag($ImageURL, false);
	}

	if (!$ImageTag) return "";

	$Caption = "";
	$CaptionStart = mb_stripos($block_content, "<figcaption>");
	if ($CaptionStart !== false) {
		$CaptionStart += mb_strlen("<figcaption>");
		$CaptionEnd = mb_stripos($block_content, "</figcaption>", $CaptionStart);
		$Caption = mb_substr($block_content, $CaptionStart, $CaptionStart - $CaptionEnd);
		$ImageTag .= "<figcaption>".$Caption."</figcaption>";
	}

	return sprintf("<figure class=\"responsive-image-holder wp-caption alignnone\">%s</figure>", 
		$ImageTag);

}

function MSU_CustomBlockOutput($block_content, $block) {
	switch ($block["blockName"]) {
		case "core/image":
			return MSU_CustomImageOutput($block_content, $block);
		default:
			return $block_content;
	}
};

add_filter("render_block", "MSU_CustomBlockOutput", 10, 2);