<?PHP
if (!function_exists("get_header")) exit("Wordpress not loaded.");



// $isMainSite = (network_home_url() == home_url()."/")?true:false;
$isMainSite = (get_current_blog_id()==1);
$isChildTheme = get_stylesheet_directory() != get_template_directory();

function custom_page_title() {	
	global $page, $paged, $isMainSite;


	$isMainSite = (get_current_blog_id()==1);
	/*
	$fullTitle = array();

	ob_start();
	if (is_404()) {
		echo ("Page Not Found");
	} else {
		the_title();
	}
	$pageTitle = ob_get_contents();
	ob_end_clean();
	// Add the blog name.
	// bloginfo( 'name' );
	if (!is_front_page()) $fullTitle[] = $pageTitle;
	if (!$isMainSite) $fullTitle[] = get_option('blogname');
	switch_to_blog(1);
	$fullTitle[] = get_option('blogname');
	restore_current_blog();

	return implode(" - ", $fullTitle);
	*/

	// special case for University homepage
	if ($isMainSite && is_front_page()) {
		return get_option('blogname');
	}


	$retVal = ucwords(wp_title( '-', false, 'right' ));
	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 ) {
		$retVal .= sprintf( __( 'Page %s - ', 'feliciano' ), max( $paged, $page ) );
	}
	$retVal .= get_bloginfo("name");
	if (!$isMainSite) {
		$retVal .= " - ";
		switch_to_blog(1);
		$retVal .= get_option("blogname");
		restore_current_blog();
	}

	// Add the blog name.
	// bloginfo( 'name' );


	$retVal = ucwords($retVal);
	return $retVal;
}

function getOGImageTag($twitter = false) {
	$inURL = get_the_post_thumbnail_url(null, "original");
	if (!$inURL || empty($inURL)) return "";
	$imgID = mpGetIDFromURL($inURL);
	$altText = get_post_meta($imgID, '_wp_attachment_image_alt', true);	

	$inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $inURL);
	$retVal = "";
	$retVal = "<meta property=\"".($twitter?"twitter:image":"og:image")."\" content=\"";
	$retVal .= network_home_url("/responsive-media/cache".$inURL.".5.1x.generic.jpg");
	$retVal .= "\" />\n";
	if (!empty($altText)) {
		$retVal .= sprintf("<meta property=\"%s:image:alt\" content=\"%s\" />\n",
			$twitter?"twitter":"og",
			htmlspecialchars($altText, ENT_QUOTES));
	}
	return $retVal;
}

$DisplayCalendar = false;
if (boolval(get_option("CalendarHomepage")) || (intcheck(get_option("CalendarID"))!==null) ||
	(intcheck(get_option("CalendarListID"))!==null)) {
	$DisplayCalendar = true;
}

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2, user-scalable=yes" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />

		<?PHP 
		if ($_SERVER["HTTP_HOST"]=="www.montclair.edu" 
			&& preg_match("/siteimprove\.com/i", $_SERVER["HTTP_USER_AGENT"], $matches)==0
			&& !dnt_user()) {
			@include (dirname(__FILE__)."/google-tag-manager.php");
		}
		?>

		<title><?php echo custom_page_title(); ?></title>

		<!-- Standard Meta Description for Google Snippet -->
		<?PHP 
			$excerpt = get_the_excerpt();
			if ($excerpt && !empty($excerpt)) {
					$excerpt = htmlspecialchars(html_entity_decode($excerpt), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');
					echo "<meta name=\"description\" content=\"".$excerpt."\" />\n";
			}
		?>

		<!-- Robots no-index, no-follow for old news -->
		<?PHP 
			// find out the max age from the site options
			$archive_after = get_option("ArchiveNewsAfter");
			// if this is a post AND there's a maximum age
			if ("post" == @get_post_type() && is_numeric($archive_after)) {
				// convert the archive age to seconds
				$archive_after = intval($archive_after * 24*60*60);
				// get the post's age in seconds
				$post_age = (time() - strtotime(get_the_date("c")));
				// if this post is "old" then output the robots text
				if ($post_age > $archive_after) {
					echo ("<meta name=\"robots\" content=\"noindex, nofollow\">\n");
				}
			}
		?>

		<?PHP 
		// if NOT (HTTP_HOST says we're in the sandbox)
		if (!(isset($_SERVER["HTTP_HOST"]) && $_SERVER["HTTP_HOST"]=="localhost")) {
			?>
			<!-- favicons -->
			<link rel="icon" href="<?PHP echo get_template_directory_uri() ?>/msu-shield-only.png" sizes="any">
			<link rel="icon" href="<?PHP echo get_template_directory_uri() ?>/msu-shield-only.svg" type="image/svg+xml">
			<?PHP
		}
		?>

		<!-- Twitter Card Info (uses Open Graph data) -->
		<meta name="twitter:card" content="summary_large_image" />
		<meta name="twitter:site" content="@montclairstateu" />
		<meta name="twitter:title" content="<?PHP echo htmlspecialchars(html_entity_decode(get_the_title()), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>" />
		<?PHP 
			if ($excerpt && !empty($excerpt)) {
					echo "<meta property=\"twitter:description\" content=\"".$excerpt."\" />\n";
			}
		?>
		<?PHP echo getOGImageTag(true); ?>

		<!-- Open Graph Protocol metadata -->
		<meta property="og:type" content="article" />
		<meta property="og:title" content="<?PHP echo htmlspecialchars(html_entity_decode(get_the_title()), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>" />
		<?PHP 
			if ($excerpt && !empty($excerpt)) {
					echo "<meta property=\"og:description\" content=\"".$excerpt."\" />\n";
			}
		?>
		<?PHP echo getOGImageTag(); ?>
		<meta property="og:url" content="<?PHP echo get_page_link();?>" />
		
		<!-- <link rel="stylesheet" type="text/css" href="<?PHP echo get_template_directory_uri() ?>/style.css" /> -->
		<?PHP 
		if ($isChildTheme) {
			?>
			<!-- <link rel="stylesheet" type="text/css" href="<?PHP echo get_stylesheet_directory_uri(); ?>/style.css" /> -->
			<?PHP
		}
		?>

		<script type="text/javascript">
			window.themeRoot = "<?PHP echo get_template_directory_uri();?>";
			window.childRoot = "<?PHP echo get_stylesheet_directory_uri();?>";
			/* ensureCSS */
			function ensureCSS(a){var b=document.createElement("div");b.innerHTML='<a href="'+a+'">'+a+"</a>";for(var c=b.firstChild.href,d=document.getElementsByTagName("LINK"),e=0;e<d.length;e++)if(d[e].href==c)return!1;var f=document.createElement("link");return f.rel="stylesheet",f.type="text/css",f.href=c,document.head.appendChild(f),!0}

			<?PHP 
			if ($DisplayCalendar) {
				$CalOpts = array();
				$CalOpts["show"] = true;
				if (boolval(get_option("CalendarHomepage"))) {
					$CalOpts["homepage"] = true;
				} else if (intcheck(get_option("CalendarListID"))!==null) {
					$CalOpts["ListID"] = intcheck(get_option("CalendarListID"));
				} else if (intcheck(get_option("CalendarID"))!==null) {
					$CalOpts["id"] = intcheck(get_option("CalendarID"));
				}
				echo "window.sidebarCalendarOptions =".json_encode($CalOpts).";";
			} ?>
		</script>

		<?PHP wp_head(); ?>
	</head>
	<body <?php body_class($isMainSite?" homepage":""); ?>><div style="height: 0; width: 0; position: absolute; visibility: hidden"><?PHP 
		// include university-wide SVG spritesheet
		echo preg_replace("/[\\r\\n]/i", "", file_get_contents(get_template_directory()."/sprite-sheet.svg"));
		// if this is a child theme and the child theme has a sprite sheet, include that too.
		if ($isChildTheme && file_exists(get_stylesheet_directory()."/sprite-sheet.svg")) {
			echo preg_replace("/[\\r\\n]/i", "", file_get_contents(get_stylesheet_directory()."/sprite-sheet.svg"));
		}
	?></div><nav aria-label="Accessibility Navigation"><!-- Google Tag Manager (noscript) --><noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-PQ6QXHQ" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript><!-- End Google Tag Manager (noscript) --><a href="#content-start" class="a11y-link" id="SkipToContent">Skip to Content</a></nav>
		<header class="page-header">
			<span class="site-identification">
			<span class="msu-logo"><div><a href="/" name="Montclair State University" aria-label="Montclair State University"><span class="a11y-label">Montclair State University</span>
				<svg viewbox="0 0 225 45"><use xlink:href="#msu-logo-2023" /></svg>
			</a></div></span><?PHP 
			if (!$isMainSite) {
				?><span class="subsite"><a href="<?PHP bloginfo("url");?>/"><?PHP bloginfo("title");?></a></span><?PHP	
			}
			?></span>
		</header>
		<nav class="header-navigation<?PHP echo (!$isMainSite?" subsite":"");?>" aria-label="Site Navigation"><?PHP 
			if ($isChildTheme && file_exists(get_stylesheet_directory()."/header-menu-custom.php")) {
				include(get_stylesheet_directory()."/header-menu-custom.php");
			} else {
			?>
			<div class="side-tags">
				<span class="nav-tab menu"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-menu" /></svg></div><a href="javascript: ;">Menu</a></span>
				<span class="nav-tab search"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-search" /></svg></div><a href="javascript: ;">Search</a></span>
				<?PHP
					if ($DisplayCalendar) {
						?>
						<span class="nav-tab calendar"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#calendar" /></svg></div><a href="javascript: ;">News&nbsp;&amp;&nbsp;Events</a></span>
						<?PHP 
					}
				?>
				<?PHP
					$ApplyURL = get_option("ApplyURL");
					if (gettype($ApplyURL)=="string" && !empty($ApplyURL)) {
						?>
						<span class="nav-tab apply"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-apply" /></svg></div><a href="<?PHP echo htmlentities($ApplyURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>">Apply</a></span>
						<?PHP
					} 
					$GiveURL = get_option("GiveURL");
					if (gettype($GiveURL)=="string" && !empty($GiveURL)) {
						?>
						<span class="nav-tab give"><div class="icon"><svg viewBox="0 0 100 100"><use xlink:href="#gift-icon" /></svg></div><a href="<?PHP echo htmlentities($GiveURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>">Give Now</a></span>
						<?PHP
					} 
				?>
				<?PHP 
					// look for quicklinks menu
					$quicklinksMenu = has_nav_menu("quicklinks_nav");
					if ($quicklinksMenu) {
						?>
						<span class="nav-tab links"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-toolbox" /></svg></div><a href="javascript: ;">Toolbox</a></span>
						<?PHP
					}
				?>
			</div><div class="mobile-tags">
				<span class="nav-tab search"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-search" /></svg></div><a href="javascript: ;">Search</a></span>
				<span class="nav-tab menu"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-menu" /></svg></div><a href="javascript: ;">Menu</a></span>
			</div><?PHP 
			}
			?><div class="sidebar-wrapper">
				<div class="close-button"><a href="javascript: ;" aria-label="Close Menu"><svg viewBox="0 0 30 30"><use xlink:href="#close-x" /></svg></a></div>
				<div class="sidebar-content">
					<div class="sidebar-menu<?PHP echo (boolval(get_option("AdditionalSidebarToggle"))?" has-additional-content":""); ?>" style="display: block;">
						<?PHP if (gettype($ApplyURL)=="string" && !empty($ApplyURL)) { ?>
							<p class="mobile-tab-dupe"><span class="prpl-button full-width"><a href="<?PHP echo htmlentities($ApplyURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>">Apply</a></span></p>
						<?PHP } ?>
						<?PHP 
							if (!$isMainSite) {
								?><p class="subsite-sidebar-header"><a href="<?PHP bloginfo("url");?>/"><?PHP bloginfo("title");?></a></p><?PHP	
							}
						?>
						<?PHP wp_nav_menu(array("menu" => "Primary Menu", "container_class" => "foldable-menu", "depth"=>"2")); ?>
						<?PHP if (boolval(get_option("AdditionalSidebarToggle"))) {
							echo get_option("AdditionalSidebarContent");
						} ?>
					</div>
					<div class="sidebar-search" style="display: block;" tabindex="-1" role="region" aria-label="Sidebar Search Form">
						<div class="search-form">
							<form action="/search.php" method="get">
								<label for="SidebarSearchInput">What can we help you find?</label>
								<span class="input-wrapper"><input type="search" name="q" id="SidebarSearchInput" placeholder="search" aria-controls="SidebarSearchOutputCount"/></span>
								<div id="SidebarSearchOutputCount" class="results" aria-live="polite" aria-relevant="all" role="region" aria-label="Result Count"></div>
								<div id="SidebarSearchOutput" class="results" aria-live="off"></div>
								<span class="button-wrapper"><input type="submit" name="sa" value="View All Results" /></span>
							</form>
						</div>
					</div>
				<?PHP 
						if ($DisplayCalendar) { 
						?>
						<div class="sidebar-calendar" style="display: block;">
							<h2>University News</h2>
							<div class="news-output"><?PHP OutputHeaderNewsFeed();?></div>
							<p><span class="button-wrapper"><a href="//www.montclair.edu/newscenter/university-news/">View News</a></span></p>
							<h2>Upcoming Events</h2>
							<div class="calendar-output"><p>Loading Calendar Items &hellip;</p></div>
							<p><span class="button-wrapper"><a href="//www.montclair.edu/calendar/">View Calendar</a></span></p>
						</div>
						<?PHP 
						} 
						if ($quicklinksMenu) {
							?>
							<div class="sidebar-links">
								<div class="quicklinks-menu">
									<h2><?PHP bloginfo("title");?> Toolbox</h2>
									<?PHP 
										ob_start();
										wp_nav_menu(array("theme_location"=>"quicklinks_nav", "depth"=>"1")); 
										$qlm = ob_get_contents();
										ob_end_clean();
										$qlm = preg_replace('/id=\"[^\"]+\"/i', "", $qlm);
										echo $qlm;
										include(dirname(__FILE__)."/toolbar-links.php"); 
									?>
								</div>
							</div>
							<?PHP
						}
					?>
				</div>
				<div class="sidebar-social">
					<ul>
						<li><a href="https://twitter.com/montclairstateu" class="twitter" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#x-twitter" /></svg>University Twitter</a></li>
						<li><a href="https://www.facebook.com/MontclairStateUniversity" class="facebook" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#facebook" /></svg>University Facebook</a></li>
						<li><a href="https://www.instagram.com/montclairstateu/" class="instagram" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#instagram-new" /></svg>University Instagram</a></li>
						<li><a href="https://www.youtube.com/@montclairstateu" class="youtube" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#youtube" /></svg>University YouTube</a></li>
						<li><a href="https://www.tiktok.com/@montclairstateu" class="tik-tok" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#tik-tok" /></svg>University Tik-Tok</a></li>
					</ul>
				</div>
			</div>
		</nav>
		
