<?php
/**
 * The loop that displays a single post.
 *
 * The loop displays the posts and the post content. See
 * http://codex.wordpress.org/The_Loop to understand it and
 * http://codex.wordpress.org/Template_Tags to understand
 * the tags used in it.
 *
 * This can be overridden in child themes with loop-single.php.
 *
 * @package WordPress
 * @subpackage Twenty_Ten
 * @since Twenty Ten 1.2
 */

if (have_posts()) {
	while (have_posts()) {
		the_post(); ?>

		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<?PHP
				if (has_post_thumbnail()) {
					?><div class="post-thumbnail"><?PHP the_post_thumbnail("Blog Thumbnail");?></div><?PHP
				}
			?>

			<h1 class="post-title"><?php the_title(); ?></h1>

			<p class="posted">
			<?php the_time('l M d, Y'); ?> &nbsp;|&nbsp; 
			<?php comments_popup_link(__('0 comments','njnewscommons'), __('1 comment','njnewscommons'), __('% comments','njnewscommons'),'', ''); ?>
			<?php edit_post_link("Edit", " | "); ?>
			</p>

			<div class="storycontent">
				<?php echo get_the_term_list( $post->ID, 'writer', '<p class="byline">by <span class="writer">', ', ', '</span></p>' ); ?> 
				<?php the_content(); ?>
			</div><!-- .entry-content -->

		</div><!-- #post-## -->

		<div id="comment">
			<?php comments_template(); ?>
		</div>


<?php 
	}
}
?>
