<?PHP 

function msu_add_meta_box() {
	add_meta_box(
		"msu-theme-meta",
		esc_html__("Theme Settings", "example"),
		"msu_meta_box_callback",
		array("page", "page_alt"),
		"side",
		"default"
	);
}


function msu_meta_box_callback($post) {
	$hpos = get_post_meta($post->ID, "msu_theme_header_hpos", true);
	$vpos = get_post_meta($post->ID, "msu_theme_header_vpos", true);
	$lang = get_post_meta($post->ID, "msu_theme_lang", true);

	$valid_hpos = array("left", "center", "right");
	if (!in_array($hpos, $valid_hpos)) $hpos = "center";
	$valid_vpos = array("top", "center", "bottom");
	if (!in_array($vpos, $valid_vpos)) $vpos = "center";


	?>
	<?PHP wp_nonce_field(basename(__FILE__), "msu_meta_box_nonce"); ?>

	<p>
		<label for="msu-theme-header-hpos">Header Horizontal Position:</label><br />
		<select name="msu-theme-header-hpos" id="msu-theme-header-hpos">
			<?PHP 
			foreach ($valid_hpos as $val) {
				echo ("<option value='".$val."' ".($val==$hpos?"selected":"").">".ucwords($val)."</option>");
			}
			?>
		</select>
	</p>
	<p>
		<label for="msu-theme-header-vpos">Header Vertical Position:</label><br />
		<select name="msu-theme-header-vpos" id="msu-theme-header-vpos">
			<?PHP 
			foreach ($valid_vpos as $val) {
				echo ("<option value='".$val."' ".($val==$vpos?"selected":"").">".ucwords($val)."</option>");
			}
			?>
		</select>
	</p>
	<p>
		<label for="msu-theme-lang">Page Language:</label><br />
		<input type="text" name="msu-theme-lang" id="msu-theme-lang" value="<?PHP echo htmlspecialchars($lang);?>" />
	</p>

	<?PHP 
}

function msu_save_meta_box($post_id) {

/*
	$inPost = get_post($post_id);
	if (!$inPost) return;
	if ($inPost->post_parent) {
		$parentPost = get_post($inPost->post_parent);
		if ($parentPost) $post_id = $parentPost->ID;
	}
*/

	if (!isset($_POST["msu_meta_box_nonce"]) || !wp_verify_nonce($_POST["msu_meta_box_nonce"], basename(__FILE__))) {
		return $post_id;
	}
	$post = get_post($post_id);
	if (!$post) {
		return $post_id;
	}

	$post_type = get_post_type_object($post->post_type);

	if (!current_user_can($post_type->cap->edit_post, $post_id)) {
		return $post_id;
	}

	$hpos = $_POST["msu-theme-header-hpos"];
	$vpos = $_POST["msu-theme-header-vpos"];
	$lang = $_POST["msu-theme-lang"];

	$valid_hpos = array("left", "center", "right");
	if (!in_array($hpos, $valid_hpos)) $hpos = "center";
	$valid_vpos = array("top", "center", "bottom");
	if (!in_array($vpos, $valid_vpos)) $vpos = "center";

	$lang = preg_replace("/[^a-zA-Z-]/", "", $lang);

	$old_hpos = get_post_meta($post_id, "msu_theme_header_hpos", true);
	$old_vpos = get_post_meta($post_id, "msu_theme_header_vpos", true);

	if (!in_array($old_hpos, $valid_hpos)) {
		add_post_meta($post_id, "msu_theme_header_hpos", $hpos, true);
	} else {
		update_post_meta($post_id, "msu_theme_header_hpos", $hpos);
	}

	if (!in_array($old_vpos, $valid_vpos)) {
		add_post_meta($post_id, "msu_theme_header_vpos", $vpos, true);
	} else {
		update_post_meta($post_id, "msu_theme_header_vpos", $vpos);
	}

	delete_post_meta($post_id, "msu_theme_lang");
	if (!empty($lang)) add_post_meta($post_id, "msu_theme_lang", $lang, true);
}



function msu_meta_boxes_setup() {
	add_action("add_meta_boxes", "msu_add_meta_box");
	add_action("save_post", "msu_save_meta_box");
}



add_action("load-post.php", "msu_meta_boxes_setup");
add_action("load-post-new.php", "msu_meta_boxes_setup");