<?PHP 
// Adding titles to iframes for accessibility.
add_filter( 'oembed_dataparse', 'filter_oembed_dataparse', 10, 3 );


/**
 * Filters the returned oEmbed HTML.
 *
 * @param   string - $return - The returned oEmbed HTML.
 * @param   object - $data - A data object result from an oEmbed provider.
 * @param   string - $url - The URL of the content to be embedded.
 * @return  string - the HTML.
 */
function filter_oembed_dataparse( $return, $data, $url ) {

	// Get title from embed data to start.
	$title = ! empty( $data->title ) ? $data->title : '';

	// If no embed title, search the return markup for a title attribute.
	$preg_match = '/title\=[\"|\\\']{1}([^\"\\\']*)[\"|\\\']{1}/i';
	$has_title_attr = preg_match( $preg_match, $return, $matches );
	if ( $has_title_attr && ! empty( $matches[1] )) {
		$title = $matches[1];
	}

	// Add embed type as title prefix.
	if ( $title && ! empty( $data->type ) ) {
		switch( $data->type ) {

			// Capitalize first word.
			case 'video':
				$title = sprintf( __( '%s:', 'wpcampus' ), ucfirst( $data->type ) ) . ' ' . $title;
				break;
		}
	}

	// $title = apply_filters( 'wpcampus_oembed_title', $title, $return, $data, $url );

	/*
		* If the title attribute already
		* exists, replace with new value.
		*
		* Otherwise, add the title attribute.
		*/
	/*
	if ( $has_title_attr ) {
		$return = preg_replace( $preg_match, 'title="' . $title . '"', $return );
	} else {
		$return = preg_replace( '/^\<iframe/i', '<iframe title="' . $title . '"', $return );
	}
	if (preg_match('/frameborder/i', $return) !== false) {
		$return = preg_replace( '/frameborder=\"[^\"]+\"/i', "", $return);
		$return = str_replace(style)
	}
	*/

	$dom = new DOMDocument();
	$dom->LoadHTML($return);
	$node = $dom->GetElementsByTagName("iframe");
	if ($node->length > 0) {
		$node = $node->item(0);

		// set title
		$node->setAttribute("title", $title);
	
		// remove HTML attribute formatting - convert to css
		$width = $node->getAttribute("width");
		$height = $node->getAttribute("height");
		if ($width && $height) {
			$node->setAttribute("style", $node->getAttribute("style").sprintf("width: %dpx; height: %dpx;", $width, $height));
		}
		$node->removeAttribute("width");
		$node->removeAttribute("height");
		$frameborder = $node->getAttribute("frameborder");
		if (is_numeric($frameborder)) {
			$node->setAttribute("style", $node->getAttribute("style").sprintf(" border: %dpx solid #000;", $frameborder));
		}
		$node->removeAttribute("frameborder");
	
		// output HTML - but of course our servers have really old PHP so we can't just output the node
		$return = $dom->SaveHTML();
		$start = mb_stripos($return, "<iframe");
		$end = mb_stripos($return, "</iframe>");
		$return = mb_substr($return, $start, $end-$start)."</iframe>";
	} else {
		$return = "<!-- unable to parse oembed using DOM -->".$return;
	}

	return $return;
}
