<?PHP

$GLOBALS["AllowEditorThemeOptions"] = true;

if (!function_exists("boolval")) {
	function boolval($inVal) {
		if (is_bool($inVal)) return $inVal;
		if (is_numeric($inVal)) return !($inVal==0);
		if (is_string($inVal)) return (trim(strtolower($inVal))==true);
		return null;
	}
}

if (!function_exists("intcheck")) {
	function intcheck($inVal) {
		if (!is_numeric($inVal)) return null;
		return intval($inVal);
	}
}

add_action ("admin_init", "MSU_ThemeOptionsInit");
function MSU_ThemeOptionsInit() {
	register_setting("MSU_ThemeSettings", "LeftMenuTopLevel", "boolval");
	register_setting("MSU_ThemeSettings", "ApplyURL");
	register_setting("MSU_ThemeSettings", "GiveURL");
	register_setting("MSU_ThemeSettings", "AdditionalSidebarToggle", "boolval");
	register_setting("MSU_ThemeSettings", "AdditionalSidebarContent");
	register_setting("MSU_ThemeSettings", "AdvertiserTargeting");
	register_setting("MSU_ThemeSettings", "CalendarHomepage", "boolval");
	register_setting("MSU_ThemeSettings", "CalendarID", "intcheck");
	register_setting("MSU_ThemeSettings", "CalendarListID", "intcheck");
	register_setting("MSU_ThemeSettings", "FooterMenuLabel");
	register_setting("MSU_ThemeSettings", "DisplayRelated", "boolval");
	register_setting("MSU_ThemeSettings", "RepositionH1", "boolval");
	register_setting("MSU_ThemeSettings", "ShowMenuAlways", "boolval");
	register_setting("MSU_ThemeSettings", "HidePostThumbs", "boolval");
	register_setting("MSU_ThemeSettings", "ArchiveNewsAfter", "intcheck");
}

if ($GLOBALS["AllowEditorThemeOptions"]) add_filter("option_page_capability_MSU_ThemeSettings", "MSU_ThemeOptionsPermissions");
function MSU_ThemeOptionsPermissions() {
	return 'edit_theme_options';
}

add_action ("admin_menu", "MSU_ThemeOptionsMenu");
function MSU_ThemeOptionsMenu() {
	if ($GLOBALS["AllowEditorThemeOptions"]) {
		add_submenu_page(
			'themes.php',
			'Theme Options',
			'Theme Options',
			'edit_theme_options',
			'msu-2016-theme-options',
			'MSU_ThemeOptionsMenuCallback' );	
	} else {
		add_submenu_page(
			'options-general.php',
			'Theme Options',
			'Theme Options',
			'manage_options',
			'msu-2016-theme-options',
			'MSU_ThemeOptionsMenuCallback' );	
	}
}

function MSU_ThemeOptionsMenuCallback() {
	if ($GLOBALS["AllowEditorThemeOptions"]) {
		if (!current_user_can('edit_theme_options'))  {
			wp_die( __('You do not have sufficient permissions to access this page.') );
		}
	} else {
		if (!current_user_can('manage_options'))  {
			wp_die( __('You do not have sufficient permissions to access this page.') );
		}
	}
	
	?>
	<div class="wrap">
	<h2>Montclair State University Theme Options</h2>
	<form method="POST" action="options.php">
		<?PHP 
			settings_fields("MSU_ThemeSettings");
			do_settings_sections("MSU_ThemeSettings");
		?>
		<table class="form-table">
			<tr valign="top">
				<th scope="row">Display top-level page in left menu</th>
				<td><input type="checkbox" name="LeftMenuTopLevel" <?PHP if (boolval(get_option("LeftMenuTopLevel"))) echo "checked=\"checked\" "; ?> /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Relocate H1 tag to content area</th>
				<td><input type="checkbox" name="RepositionH1" <?PHP if (boolval(get_option("RepositionH1"))) echo "checked=\"checked\" "; ?> /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Always show menu in left column</th>
				<td><input type="checkbox" name="ShowMenuAlways" <?PHP if (boolval(get_option("ShowMenuAlways"))) echo "checked=\"checked\" ";?>/></td>
			</tr>
			<tr valign="top">
				<th scope="row">Display homepage calendar feed</th>
				<td><input type="checkbox" name="CalendarHomepage" <?PHP if (boolval(get_option("CalendarHomepage"))) echo "checked=\"checked\" "; ?> /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Display calendar by ID</th>
				<td><input type="text" name="CalendarID" value="<?PHP echo intcheck(get_option("CalendarID"));?>" /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Display calendar by List ID</th>
				<td><input type="text" name="CalendarListID" value="<?PHP echo intcheck(get_option("CalendarListID"));?>" /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Hide posts from search after this many days:</th>
				<td><input type="text" name="ArchiveNewsAfter" value="<?PHP echo intcheck(get_option("ArchiveNewsAfter"));?>" /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Apply URL (Leave blank for none)</th>
				<td><input type="text" name="ApplyURL" value="<?PHP echo htmlspecialchars(get_option("ApplyURL"), ENT_COMPAT|ENT_QUOTES, "UTF-8");?>" /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Giving URL (Leave blank for none)</th>
				<td><input type="text" name="GiveURL" value="<?PHP echo htmlspecialchars(get_option("GiveURL"), ENT_COMPAT|ENT_QUOTES, "UTF-8");?>" /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Display additional sidebar content</th>
				<td><input type="checkbox" name="AdditionalSidebarToggle" <?PHP if (boolval(get_option("AdditionalSidebarToggle"))) echo "checked=\"checked\" "; ?> /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Additional sidebar content</th>
				<td><?PHP wp_editor(get_option("AdditionalSidebarContent"), "AdditionalSidebarContent", array("media_buttons"=>false)) ?></td>
			</tr>
			<tr valign="top">
				<th scope="row">Advertiser Targeting</th>
				<td><textarea name="AdvertiserTargeting" style="box-sizing: border-box; width: 100%; height: 10em;"><?PHP echo htmlspecialchars(get_option("AdvertiserTargeting"));?></textarea></td>
			</tr>
			<tr valign="top">
				<th scope="row">Footer Menu Label</th>
				<td><input type="text" name="FooterMenuLabel" value="<?PHP echo htmlspecialchars(get_option("FooterMenuLabel"), ENT_COMPAT|ENT_QUOTES, "UTF-8");?>" /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Hide Post Thumbnails</th>
				<td><input type="checkbox" name="HidePostThumbs" <?PHP if (boolval(get_option("HidePostThumbs"))) echo "checked=\"checked\" "; ?> /></td>
			</tr>
			<tr valign="top">
				<th scope="row">Display Related Posts</th>
				<td><input type="checkbox" name="DisplayRelated" <?PHP if (boolval(get_option("DisplayRelated"))) echo "checked=\"checked\" "; ?> />
				<p><em>Please note: In order to display related posts, you will need to use Tags to attach keywords to your posts.</em></p></td>
			</tr>
		</table>
		<?PHP submit_button(); ?>
	</form>
	</div>
	<?PHP
}
?>