<?php
/*
Template Name: Basic MSU 2016 Page
*/
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package WordPress
 * @subpackage Blank_Theme
 * @since Blank Theme 1.0
 */

if (!function_exists("get_header")) exit("Wordpress not loaded.");

get_header(); 

include_once(dirname(__FILE__)."/base64_image.php");

// build the left menu
$tmp = wp_get_nav_menu_items("Header Menu");
$children = MSU_CollectChildren($tmp);
$tmp = MSU_BuildLeftMenu($children, get_the_ID(), boolval(get_option("LeftMenuTopLevel")), get_post_type());

// if there's no left menu, build a default one for the homepage
// (this behavior may change later to display full-width content column instead)
if (!$tmp && boolval(get_option("ShowMenuAlways"))) {
	// we must re-fetch this data because of the use of STD Objects
	// the menu building process above alters some values and even though the arrays are
	// passed by value, objects in arrays function essentially as pointers. That means the
	// MSU_BuildLeftMenu function can be destructive when LeftMenuTopLevel is set
	$tmp = wp_get_nav_menu_items("Header Menu");
	$children = MSU_CollectChildren($tmp);
	$tmp = MSU_BuildLeftMenu($children, intval(get_option("page_on_front")), boolval(get_option("LeftMenuTopLevel")));
}

$LeftMenu = str_replace("<ul></ul>", "", $tmp); 
$imgtag = null;
if (has_post_thumbnail()) {
	ob_start();
	the_post_thumbnail_url("full");
	$imgtag = getResponsiveImageTag(ob_get_contents(), true);
	ob_end_clean();
	// see if we can find the URL of the background image and pull it in
	$found = preg_match("/src=\\\"([^\\\"]+)\\\"/i", $imgtag, $match);
	if ($found) {
		$thumbURL = $match[1];
	} else {
		$thumbID = get_post_thumbnail_id($post->ID);
		$thumbURL = wp_get_attachment_url($thumbID);
		$thumbURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $thumbURL);
		$thumbURL = "/responsive-media/cache".$thumbURL.".0.1x.generic.jpg";
	}
}

$hpos = get_post_meta($post->ID, "msu_theme_header_hpos", true);
$vpos = get_post_meta($post->ID, "msu_theme_header_vpos", true);
$lang = get_post_meta($post->ID, "msu_theme_lang", true);

$valid_hpos = array("left", "center", "right");
if (!in_array($hpos, $valid_hpos)) $hpos = "center";
$valid_vpos = array("top", "center", "bottom");
if (!in_array($vpos, $valid_vpos)) $vpos = "center";

$bg_style = "background-position: ".$hpos." ".$vpos;



?>


<main>
		

		<div class="page-middle">
			<div class="prpl-menu-column">
				<nav class="prpl-left-menu" aria-label="Page Menu">
					<?PHP echo $LeftMenu; ?>
				</nav>
			</div><!-- div.prpl-menu-column -->
			<div class="prpl-hero" 
				<?PHP if (isset($thumbURL) && !empty($thumbURL)) echo("style=\"background-image: url(".$thumbURL.");".$bg_style." \""); ?> 
				<?PHP if ($lang) echo sprintf("lang=\"%s\"", htmlspecialchars($lang));?> >
				<?PHP 
				if (has_post_thumbnail()) {
					echo $imgtag;
				} ?>
				<?PHP if (!boolval(get_option("RepositionH1"))) echo sprintf("<div class=\"header-scrim\"><h1 id=\"content-start\">%s</h1></div>", get_the_title());?>
			</div>
			<article class="prpl-content-column" <?PHP if ($lang) echo sprintf("lang=\"%s\"", htmlspecialchars($lang));?> >
			<?PHP			
				if (boolval(get_option("RepositionH1"))) echo sprintf("<h1 id=\"content-start\">%s</h1>", get_the_title());
if (have_posts()) {
	while (have_posts()) {
		the_post(); 
		the_content();
	}
}
?></article><!-- div.prpl-content-column -->
		</div><!-- div.page-middle -->
		</main>

<?PHP
get_footer(); 
?>
