<?PHP

class CTemplateSettings {
	public $pageBody = "";
	public $pageTitle = "";
	public $pageSummary = ""; // for OG description
	public $pageThumbnail = ""; // for OG thumbnail
	public $pageThumbnailAlt = ""; // for OG thumbnail

	public $additionalCSS = "";
	public $additionalJS = "";

	public $displaySiteName = false;
	public $siteName = "";
	public $siteURL = "";

	public $displayMenu = true;
	public $displayFooterMenu = true;
	public $menu = array();
	public $displayMenuWithoutMatch = false;

	public $additionalMenuContent = false;

	public $contentColumnClasses = array();

	public $heroImage = "";
	public $heroImageClasses = array();
	public $heroImageAlt = "";
	public $heroLabel = null;

	public $pageMiddleClasses = array();

	public $displayCalendar = false;
	public $calendarID = 0;
	public $calendarSpecial = false;

	public $displayApply = false;
	public $applyLink = "";

	public $trackingCode = "";

	public $displayAdditionalSidebar = false;
	public $additionalSidebar = "";

	public $matchURL = "";

	public $allowCache = false; // by default, don't allow caching since this is mostly for web apps

	function __construct() {
		$this->matchURL = $_SERVER["PHP_SELF"];

		// default menu - take the footer menu and replace
		// <li><a href="([^\"]+)">([^<]+)</a></li>
		// $this->menu[] = array("url"=>"$1", "name"=>"$2", "children"=>null);

		$this->menu[] = array("url"=>"https://www.montclair.edu/about-montclair/", "name"=>"About Montclair", "children"=>null);
		$this->menu[] = array("url"=>"https://www.montclair.edu/academics/", "name"=>"Academics", "children"=>null);
		$this->menu[] = array("url"=>"https://www.montclair.edu/university-admissions/", "name"=>"Admissions", "children"=>null);
		$this->menu[] = array("url"=>"https://www.montclair.edu/alumni/", "name"=>"Alumni", "children"=>null);
		$this->menu[] = array("url"=>"/red-hawk-life/arts-and-culture/", "name"=>"Arts and Culture", "children"=>null);
		$this->menu[] = array("url"=>"https://www.montclairathletics.com/", "name"=>"Athletics", "children"=>null);
		$this->menu[] = array("url"=>"https://www.montclair.edu/red-hawk-life/", "name"=>"Red Hawk Life", "children"=>null);
		$this->menu[] = array("url"=>"/giving/", "name"=>"Giving", "children"=>null);
		$this->menu[] = array("url"=>"/research/", "name"=>"Research", "children"=>null);
	}

}


function TemplateBuildPageTitle($inSettings) {	

	$fullTitle = array();

	$fullTitle[] = $inSettings->pageTitle;
	if ($inSettings->displaySiteName && $inSettings->siteName != $inSettings->pageTitle) {
		$fullTitle[] = $inSettings->siteName;
	}
	$fullTitle[] = "Montclair State University";

	return implode(" - ", $fullTitle);
}

function get_stylesheet_directory_uri() {
	return "/wp-content/themes/msu-prpl";
}

function get_template_directory_uri() {
	return get_stylesheet_directory_uri();
}

function get_stylesheet_directory() {
	return $_SERVER["DOCUMENT_ROOT"]."/wp-content/themes/msu-prpl";
}



function TemplateBuildMenu($inMenu, $inMatchURL, $inLevel=0, $inMaxLevel=10, $returnWithoutMatch=false) {
	if ($inLevel>=$inMaxLevel) return null;
	if (!is_array($inMenu)) return null;

	$containsMatch = false;
	$outHTML = "";

	$outHTML .= "<ul class=\"menu\">";
	foreach($inMenu as $m) {
		$liClass = "menu-item";
		if ($m["url"]==$inMatchURL) {
			$childHTML = TemplateBuildMenu($m["children"], $inMatchURL, $inLevel+1, $inMaxLevel, true);
			$containsMatch = true;
			$liClass .= " current-page";
		} else {
			$childHTML = TemplateBuildMenu($m["children"], $inMatchURL, $inLevel+1, $inMaxLevel, false);
			if ($childHTML!==null) {
				$containsMatch = true;
				$liClass .= " current-page";
			} else {
				$childHTML = "";
			}
		}
		
		$outHTML .= "<li class=\"".$liClass."\">";
		$outHTML .= "<a href=\"".htmlspecialchars($m["url"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\">";
		$outHTML .= htmlspecialchars($m["name"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');
		$outHTML .= "</a>";
		$outHTML .= $childHTML;
		$outHTML .= "</li>";
	}
	$outHTML .= "</ul>";

	if ($containsMatch || $returnWithoutMatch) return $outHTML;
	else return null;
}

function getOGImageTag($inSettings, $twitter = false) {
	$inURL = $inSettings->pageThumbnail;
	if (!$inURL || empty($inURL)) $inURL = $inSettings->heroImage;
	if (!$inURL || empty($inURL)) return "";

	$fileURL = $inURL;
	$inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $inURL);
	$newURL = "http://".$_SERVER["HTTP_HOST"]."/responsive-media/cache".$inURL.".5.1x.generic.jpg";
	$retVal = sprintf("<meta property=\"%s\" content=\"%s\" />\n",
		($twitter?"twitter:image":"og:image"),
		$newURL);
	if (!$twitter) {
		// I should be checking for whether this image is in the wp-content
		// directory and removing the site name but the PHP apps shouldn't
		// be using images from WordPress
		$fileURL = $_SERVER["DOCUMENT_ROOT"].$fileURL;
		$size = @getimagesize($fileURL);
		if (is_array($size)) {
			// adjust size to match generic 5
			$size[1] = floor($size[1]*1250/$size[0]);
			$size[0] = 1250;
			$retVal .= sprintf("<meta property=\"og:image:width\" content=\"%d\" />\n", $size[0]);
			$retVal .= sprintf("<meta property=\"og:image:height\" content=\"%d\" />\n", $size[1]);
		}
		if (!empty($inSettings->pageThumbnailAlt)) {
			$retVal .= sprintf("<meta property=\"og:image:alt\" content=\"%s\" />\n", htmlspecialchars($inSettings->pageThumbnailAlt, ENT_QUOTES));
		}
	} else {
		if (!empty($inSettings->pageThumbnailAlt)) {
			$retVal .= sprintf("<meta property=\"twitter:image:alt\" content=\"%s\" />\n", htmlspecialchars($inSettings->pageThumbnailAlt, ENT_QUOTES));
		}
	}
	return $retVal;
}

function dnt_user() {
	return ((isset($_SERVER['HTTP_DNT']) && $_SERVER['HTTP_DNT'] == 1 ) || isset($_GET['DNT']) && $_GET['DNT'] == 1);
}

function RenderPage($inSettings) {
	if (@get_class($inSettings) !== "CTemplateSettings") exit();

	if (in_array("short", $inSettings->heroImageClasses) &&
		!in_array("short-hero", $inSettings->pageMiddleClasses)) {
		$inSettings->pageMiddleClasses[] = "short-hero";
	}

	if (!$inSettings->allowCache) {
		header("Cache-control: no-cache");
	}

?><!DOCTYPE html>
<html lang="en-US">
	<head>
		<meta charset="UTF-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2, user-scalable=yes" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />

		<?PHP 
		if ($_SERVER["HTTP_HOST"]=="www.montclair.edu" 
			&& preg_match("/siteimprove\.com/i", $_SERVER["HTTP_USER_AGENT"], $matches)==0
			&& !dnt_user()) {
			@include (dirname(__FILE__)."/google-tag-manager.php");
		}
		?>

		<title><?php echo TemplateBuildPageTitle($inSettings); ?></title>

		<?PHP 
		// if NOT (HTTP_HOST says we're in the sandbox)
		if (!(isset($_SERVER["HTTP_HOST"]) && $_SERVER["HTTP_HOST"]=="localhost")) {
			?>
			<!-- favicons -->
			<link rel="icon" href="<?PHP echo get_template_directory_uri() ?>/msu-shield-only.png" sizes="any">
			<link rel="icon" href="<?PHP echo get_template_directory_uri() ?>/msu-shield-only.svg" type="image/svg+xml">
			<?PHP
		}
		?>

		<!-- Twitter Card Info (uses Open Graph data) -->
		<meta name="twitter:card" content="summary" />
		<meta name="twitter:site" content="@montclairstateu" />
		<meta name="twitter:title" content="<?PHP echo htmlspecialchars(html_entity_decode($inSettings->pageTitle), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>" />
		<?PHP 
			$excerpt = $inSettings->pageSummary;
			if ($excerpt && !empty($excerpt)) {
					$excerpt = htmlspecialchars(html_entity_decode($excerpt), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');
					echo "<meta property=\"twitter:description\" content=\"".$excerpt."\" />\n";
			}
		?>
		<?PHP echo getOGImageTag($inSettings, true); ?>

		<!-- Open Graph Protocol metadata -->
		<meta property="og:type" content="article" />
		<meta property="og:title" content="<?PHP echo htmlspecialchars(html_entity_decode($inSettings->pageTitle), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>" />
		<?PHP 
			$excerpt = $inSettings->pageSummary;
			if ($excerpt && !empty($excerpt)) {
					$excerpt = htmlspecialchars(html_entity_decode($excerpt), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');
					echo "<meta property=\"og:description\" content=\"".$excerpt."\" />\n";
			}
		?>
		<?PHP echo getOGImageTag($inSettings, false); ?>
		<meta property="og:url" content="<?PHP echo $_SERVER["REQUEST_URI"];?>" />

		<link rel="stylesheet" type="text/css" href="<?PHP echo get_stylesheet_directory_uri() ?>/style.css?ver=<?PHP echo filemtime( get_stylesheet_directory() . '/style.css' );?>" />

		<script type="text/javascript">
			window.themeRoot = "<?PHP echo get_template_directory_uri();?>";
			window.childRoot = "<?PHP echo get_stylesheet_directory_uri();?>";
			/* ensureCSS */
			function ensureCSS(a){var b=document.createElement("div");b.innerHTML='<a href="'+a+'">'+a+"</a>";for(var c=b.firstChild.href,d=document.getElementsByTagName("LINK"),e=0;e<d.length;e++)if(d[e].href==c)return!1;var f=document.createElement("link");return f.rel="stylesheet",f.type="text/css",f.href=c,document.head.appendChild(f),!0}

			<?PHP 
			if ($inSettings->displayCalendar) {
				$CalOpts = array();
				$CalOpts["show"] = true;
				if ($inSettings->calendarSpecial) {
					$CalOpts["homepage"] = true;
				} else if ($inSettings->calendarID!==null) {
					$CalOpts["id"] = $inSettings->calendarID;
				}
				echo "window.sidebarCalendarOptions =".json_encode($CalOpts).";";
			} ?>
		</script>

		<?PHP
		echo ($inSettings->additionalCSS."\n");
		?>

	</head>
	<body><div style="height: 0; width: 0; position: absolute; visibility: hidden"><?PHP echo preg_replace("/[\\r\\n]/i", "", file_get_contents(dirname(__FILE__)."/sprite-sheet.svg"));?></div>
	<nav aria-label="Accessibility Navigation"><!-- Google Tag Manager (noscript) --><noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-PQ6QXHQ"height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript><!-- End Google Tag Manager (noscript) --><a href="#content-start" class="a11y-link" id="SkipToContent">Skip to Content</a></nav>
		<header class="page-header">
			<span class="site-identification">
				<span class="msu-logo"><div><a href="/" name="Montclair State University" aria-label="Montclair State University">
					<svg viewbox="0 0 225 45"><use xlink:href="#msu-logo-2023" /></svg>
				</a></div></span><?PHP 
					if ($inSettings->displaySiteName) {
						?><span class="subsite"><a href="<?PHP echo htmlentities($inSettings->siteURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?>"><?PHP echo $inSettings->siteName;?></a></span><?PHP	
					}
				?></span>
			
		</header>
		
		<nav class="header-navigation<?PHP echo $inSettings->displaySiteName?" subsite":"";?>" aria-label="Site Navigation">
			<div class="side-tags">
				<span class="nav-tab menu"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-menu" /></svg></div><a href="javascript: ;">Menu</a></span>
				<span class="nav-tab search"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-search" /></svg></div><a href="javascript: ;">Search</a></span>
				<?PHP
					if ($inSettings->displayCalendar) {
						?>
						<span class="nav-tab calendar"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#calendar" /></svg></div><a href="javascript: ;">Events</a></span>
						<?PHP 
					}
				?>
				<?PHP
					if ($inSettings->displayApply) {
						?>
						<span class="nav-tab apply"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-apply" /></svg></div><a href="<?PHP echo htmlentities($inSettings->applyLink, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>">Apply</a></span>
						<?PHP
					} 
				?>
			</div><div class="mobile-tags">
				<span class="nav-tab search"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-search" /></svg></div><a href="javascript: ;">Search</a></span>
				<span class="nav-tab menu"><div class="icon"><svg viewBox="0 0 30 30"><use xlink:href="#header-menu" /></svg></div><a href="javascript: ;">Menu</a></span>
			</div><div class="sidebar-wrapper">
				<div class="close-button"><a href="javascript: ;" title="close menu"><svg viewBox="0 0 30 30"><title>Close Menu</title><use xlink:href="#close-x" /></svg></a></div>
				<div class="sidebar-content">
					<div class="sidebar-menu<?PHP echo ($inSettings->displayAdditionalSidebar?" has-additional-content":""); ?>" style="display: block;">
						<?PHP if ($inSettings->displayApply) { ?>
							<p class="mobile-tab-dupe"><span class="prpl-button full-width"><a href="<?PHP echo htmlentities($inSettings->ApplyLink, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8");?>">Apply</a></span></p>
						<?PHP } ?>
						<?PHP 
							if ($inSettings->displaySiteName) {
								?><p class="subsite-sidebar-header"><a href="<?PHP echo htmlentities($inSettings->siteURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?>"><?PHP echo $inSettings->siteName;?></a></p><?PHP	
							}
						?>
						<?PHP 
							if (is_array($inSettings->menu) && count($inSettings->menu)>0) {
								echo ("<div class=\"foldable-menu\"><ul class=\"menu\">");
								foreach ($inSettings->menu as $parent) {
									echo ("<li class=\"menu-item\">");
									echo ("<a href=\"".htmlspecialchars($parent["url"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\">");
									echo (htmlspecialchars($parent["name"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8'));
									echo ("</a>");
									if (is_array($parent["children"])){
										echo ("<ul class=\"sub-menu\">");
										foreach ($parent["children"] as $child) {
											echo ("<li class=\"menu-item\">");
											echo ("<a href=\"".htmlspecialchars($child["url"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\">");
											echo (htmlspecialchars($child["name"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8'));
											echo ("</a></li>");
										}
										echo ("</ul>");
									}
									echo ("</li>");
								}
								echo ("</ul></div>");
							}
							/* wp_nav_menu(array("menu" => "Primary Menu", "container_class" => "foldable-menu", "depth"=>"2")); */ 
						?>
						<?PHP if ($inSettings->displayAdditionalSidebar) {
							echo $inSettings->additionalSidebar;
						}?>
					</div>
					<div class="sidebar-search" style="display: block;" tabindex="-1" role="region" aria-label="Sidebar Search Form">
						<div class="search-form">
							<form action="/search.php" method="get">
								<label for="SidebarSearchInput">What can we help you find?</label>
								<span class="input-wrapper"><input type="search" name="q" id="SidebarSearchInput" placeholder="search" aria-controls="SidebarSearchOutputCount"/></span>
								<div id="SidebarSearchOutputCount" class="results" aria-live="polite" aria-relevant="all" role="region" aria-label="Result Count"></div>
								<div id="SidebarSearchOutput" class="results" aria-live="off"></div>
								<span class="button-wrapper"><input type="submit" name="sa" value="View All Results" /></span>
							</form>
						</div>
					</div>
				<?PHP 
						if ($inSettings->displayCalendar) { 
						?>
						<div class="sidebar-calendar" style="display: block;">
							<h2>Upcoming Events</h2>
							<div class="calendar-output">
							</div>
							<p><span class="button-wrapper"><a href="//www.montclair.edu/calendar/">View Calendar</a></span></p>
						</div>
						<?PHP 
						} 
					?>
				</div>
				<div class="sidebar-social">
					<ul>
						<li><a href="https://twitter.com/montclairstateu" class="twitter" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#x-twitter" /></svg>Twitter</a></li>
						<li><a href="http://www.facebook.com/MontclairStateUniversity" class="facebook" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#facebook" /></svg>Facebook</a></li>
						<li><a href="https://www.instagram.com/montclairstateu/" class="instagram" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#instagram-new" /></svg>University Instagram</a></li>
						<li><a href="http://www.youtube.com/@montclairstateu" class="youtube" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#youtube" /></svg>YouTube</a></li>
					</ul>
				</div>
			</div>
		</nav>
		
		<main>
		<div class="page-middle <?PHP echo implode(" ",$inSettings->pageMiddleClasses);?>">
			<?PHP 
			if ($inSettings->displayMenu || $inSettings->additionalMenuContent) { 
				?>
				<div class="prpl-menu-column">
					<?PHP 
					if ($inSettings->displayMenu) {
						?>
						<nav class="prpl-left-menu" aria-label="Page Menu">
							<?PHP
							echo ("<p><a href=\"".htmlspecialchars($inSettings->siteURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\">");
							echo (htmlspecialchars($inSettings->siteName, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."</a></p>");
							echo TemplateBuildMenu($inSettings->menu, $inSettings->matchURL, 0, 10, $inSettings->displayMenuWithoutMatch);
							?>
						</nav>
						<?PHP
					}
					if ($inSettings->additionalMenuContent) {
						echo $inSettings->additionalMenuContent;
					}
					?>
				</div><!-- div.prpl-menu-column -->
				<?PHP 
			}
			?>
			<div class="prpl-hero <?PHP echo htmlspecialchars(implode(" ", $inSettings->heroImageClasses), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8'); ?>">
				<img 
						class="mlt-responsive-background"
						src="/responsive-media/?f=<?PHP echo htmlspecialchars($inSettings->heroImage, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?>&amp;type=generic&amp;size=0&amp;scale=1x" 
						data-original-image="<?PHP echo htmlspecialchars($inSettings->heroImage, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?>" 
						alt="<?PHP echo $inSettings->heroImageAlt; ?>"/>
				<h1 id="content-start"><?PHP echo htmlspecialchars($inSettings->heroLabel?$inSettings->heroLabel:$inSettings->pageTitle, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?></h1>
			</div>
			<div class="prpl-content-column <?PHP echo htmlspecialchars(implode(" ", $inSettings->contentColumnClasses), ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?>"><?PHP echo $inSettings->pageBody; ?></div><!-- div.prpl-content-column -->
		</div><!-- div.page-middle -->
		</main>

		<footer class="page-footer"><p class="a11y-label">Page Footer</p>
			<div class="college-hall-holder"><svg viewbox="0 0 256 256" alt=""><use xlink:href="#college-hall-footer" /></svg></div>
			<div class="site-identification">
				<div class="logo-holder">
					<div class="msu-logo"><div><a href="/" aria-label="Montclair State University"><svg viewbox="0 0 225 45"><use xlink:href="#msu-logo-2023" /></svg></a></div></div>
				</div>
				<ul class="address-links">
					<li><a href="https://www.montclair.edu/about-montclair/directions/" class="address"><span class="a11y-label">Address: 1 Normal Avenue, Montclair, New Jersey 0 7 0 4 3</span><span aria-hidden="true"><svg viewbox="0 0 30 30"><use xlink:href="#map-pin" /></svg> 1 Normal Ave.<br />Montclair, NJ 07043</span></a></li>
					<li><a href="tel:9736554000" class="phone a11y-phone-number initialized"><svg viewbox="0 0 30 30"><use xlink:href="#smartphone" /></svg><span class="a11y-label">Phone Number:</span><span class="a11y-phone-number">973-655-4000</span></a></li>
					<li><a href="https://www.montclair.edu/campus-map/" class="map"><svg viewbox="0 0 30 30"><use xlink:href="#campus-map" /></svg>Campus Map</a></li>
				</ul>
				<ul class="social-links">
					<li><a href="https://twitter.com/montclairstateu" class="twitter" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#x-twitter" /></svg>University Twitter</a></li>
					<li><a href="http://www.facebook.com/MontclairStateUniversity" class="facebook" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#facebook" /></svg>University Facebook</a></li>
					<li><a href="https://www.instagram.com/montclairstateu/" class="instagram" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#instagram-new" /></svg>University Instagram</a></li>
					<li><a href="http://www.youtube.com/@montclairstateu" class="youtube" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#youtube" /></svg>University YouTube</a></li>
					<li><a href="https://www.tiktok.com/@montclairstateu" class="tik-tok" target="_blank"><svg viewbox="0 0 30 30"><use xlink:href="#tik-tok" /></svg>University TikTok</a></li>
				</ul>
			</div>
			<div class="footer-menu">
				<?PHP 
					if ($inSettings->displaySiteName && $inSettings->displayFooterMenu) {
						?>
						<div class="column">
							<p><a href="<?PHP htmlspecialchars($inSettings->siteURL, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?>/">
							<?PHP echo htmlspecialchars($inSettings->siteName, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');?></a></p>
							<?PHP 
							if ($inSettings->displayFooterMenu && is_array($inSettings->menu)) {
								echo ("<div class=\"menu-header-menu-container\">");
								echo ("<ul class=\"menu\">");
								foreach ($inSettings->menu as $parent) {
									echo ("<li class=\"menu-item\">");
									echo ("<a href=\"".htmlspecialchars($parent["url"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\">");
									echo (htmlspecialchars($parent["name"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8'));
									echo ("</a>");
									echo ("</li>");
								}
								echo ("</ul>");
								echo ("</div>");
							}
							 ?>
						</div>
						<?PHP	
					}
				?>
				<div class="column">
					<p>Montclair State</p>
					<!-- copied from homepage 8/24/2021 -->
					<!-- don't forget to change the one in the header (line 55) -->
					<div class="menu-header-menu-container"><ul id="menu-header-menu-1" class="menu" style="display: block;"><li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-3978"><a href="https://www.montclair.edu/about-montclair/">About Montclair</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-250"><a href="https://www.montclair.edu/academics/">Academics</a></li>
<li class="menu-item menu-item-type-post_type menu-item-object-page menu-item-has-children menu-item-3528"><a href="https://www.montclair.edu/university-admissions/">Admissions</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-353"><a href="https://www.montclair.edu/alumni/">Alumni</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-252"><a href="/red-hawk-life/arts-and-culture/">Arts and Culture</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-253"><a href="https://www.montclairathletics.com/">Athletics</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-6812"><a href="https://www.montclair.edu/red-hawk-life/">Red Hawk Life</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-265"><a href="/giving/">Giving</a></li>
<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-5121"><a href="/research/">Research</a></li>
</ul></div>				</div>
				<div class="column">
					<?PHP include(dirname(__FILE__)."/footer-policies.php"); ?>
				</div>
			</div>
		</footer>
		
		<script src="<?PHP echo get_stylesheet_directory_uri();?>/jquery.min.js"></script>
		<script src="<?PHP echo get_stylesheet_directory_uri();?>/main.js"></script>
		<script type='text/javascript' src='https://www.montclair.edu/gdpr-script/gdpr-module.js?ver=1.0'></script>
		<?PHP 
		echo ($inSettings->additionalJS."\n");
		echo("<section style=\"position: absolute; width: 1px; height: 1px; left: -1000px; overflow: hidden;\" aria-label=\"retargeting pixels\">");
		echo ($inSettings->trackingCode); 
		echo("</section>");
		?>
	</body>
</html>
		<?PHP

}


?>