<?PHP
include_once(dirname(__FILE__)."/base64_image.php");

/**
 * @param string $inURL
 * @param bool $background
 * @param bool $useBase64 
 */
function getResponsiveImageTag($inURL, $background=false, $useBase64=false) {
	// see if the URL suggests that the image comes from another site in this instance
	$imageSiteID = mpGetImageSiteIDFromURL($inURL);
	$currentSiteID = get_current_blog_id();
	if ($imageSiteID != false) switch_to_blog($imageSiteID);

	$imgID = mpGetIDFromURL($inURL);
	if (!$imgID) {
		$altText = "";
	} else {
		$altText = get_post_meta($imgID, '_wp_attachment_image_alt', true);	
	}

	$discoveredURL = wp_get_attachment_image_src($imgID, "full");
	if ($discoveredURL) {
		$inURL = $discoveredURL[0];
	}
	$inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $inURL);

	$class = "mlt-responsive-image";
	if ($background==true) {
		$class="mlt-responsive-background";
	}

	$imgtag = "<img class=\"".$class."\"";
	$imgtag .= " data-original-image=\"".$inURL."\"";


	if ($imgID && $useBase64) {
		// $b64thumbnail = MSU_Base64Thumbnail(get_attached_file($imgID));
		$b64thumbnail = MSU_Base64Thumbnail($imgID);
	}
	
	if (isset($b64thumbnail) && $b64thumbnail)  {
		$imgtag .= " src=\"".$b64thumbnail."\"";
	} else {
		$imgtag .= " src=\"/responsive-media/cache".$inURL.".0.1x.generic.jpg\"";
	}
	if (!empty($altText)) {
		$imgtag .= " alt=\"".htmlspecialchars($altText, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\"";
	}
	$imgtag .= "/>";

	switch_to_blog($currentSiteID);		// switch back to this site, whether we changed or not
	return $imgtag;	
}


if (!function_exists('shortcode_empty_paragraph_fix')) {

$GLOBALS["MLTS_fix_codes"] = array();
global $MLTS_fix_codes;

function shortcode_empty_paragraph_fix($content) {
	global $MLTS_fix_codes;				// a global array of shortcodes to check
	$caret = 				0;			// a caret to step through the content
	$inShortcode = 			false;		// whether or not the caret is currently inside a shortcode
	$inQuote = 				false;		// whether or not the caret is currently inside an attribute
	$currentCode = 			null;		// the current code (i.e. [video] -> "video")
	$codeStart = 			0;			// where the current code started
	$quoteMark = 			"";			// the quotation mark used (" or ')
	$codeInArray = 			false;		// whether or not the code itself is one we're checking for

	// step through the entire content
	while ($caret < strlen($content)) {
		$codeJustFound = false;
		// if we're in the shortcode and also in a quote
		if ($inShortcode && $inQuote) {
			// if this character is a quotation mark, exit quote
			if ($content[$caret]==$quoteMark) {
				$inQuote = false;
				$quoteMark = "";
			// if this character is a backslash, just advance
			} else if ($content[$caret]=="\\") {
				$caret ++;
			}

		// if we're in the shortcode but entering a quote
		} else if ($inShortcode && ($content[$caret]=="\"" || $content[$caret]=="'")) {
			$quoteMark = $content[$caret];
			$inQuote = true;

		// if we're in the shortcode
		} else if ($inShortcode) {
			// if we don't have the current code
			if ($currentCode == null) {
				// if this character gets us the code
				if ($content[$caret]==" " || $content[$caret]=="]") {
					// store code
					$currentCode = substr($content, $codeStart+1, $caret-$codeStart-1);
					// clean up /code => code
					if ($currentCode[0]=="/") {
						$currentCode = substr($currentCode, 1);
					}
					$codeInArray = in_array($currentCode, $MLTS_fix_codes);
					if ($codeInArray && $codeStart>3) {
						// if there's <p> before the code
						if (strpos($content, "<p>", $codeStart-3)==($codeStart-3)) {
							// remove the <p>
							$content = substr($content, 0, $codeStart-3).substr($content, $codeStart);
							// move caret -3
							$caret -= 3;
						}
					}
				}
			}
			// if the caret is at "]"
			if ($content[$caret]=="]") {
				if ($codeInArray) {
					// check after caret for </p>
					if (strpos($content, "</p>", $caret+1) == ($caret+1)) {
						// splice out </p>
						$content = substr($content, 0, $caret+1).substr($content, $caret+5);
					}						
				}
				// we are no longer in a shortcode
				$inShortcode = false;
				$currentCode = null;
				$codeStart = null;
			}

		// if not in a shortcode at all
		} else {
			// increment the counter looking for the start of a code
			if ($content[$caret]=="[") {
				$n = $content[$caret+1];
				if (($n>='a' && $n<='z') || ($n>='A' && $n<='Z') || ($n=="/")) {
					$inShortcode = true;
					$currentCode = null;
					$codeStart = $caret;
					$codeInArray = false;
				}
			}
		}

		// move to the next position
		$caret++;
	}
	return $content;
}

add_filter( 'the_content', 'shortcode_empty_paragraph_fix' );

}

/*

// shortcode template


if (!function_exists("ShortcodeFunction")) {
	function ShortcodeFunction($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"", "background"=>"", "poster"=>"", "fixed"=>"false"), $atts, "shortcodename");
		
		// build the tag's class name as default + $a["class"]
		$class = "mlt-band".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"mlt-band-content\">".$content."</div>";
		if (!empty($a["background"])) {
			if (preg_match("/\\.mp4$/i", $a["background"])) {
				$class .= " mlt-band-video-background";
				$vidtag = "<video class=\"mlt-background-video\"";
				$vidtag .= " src=\"".$a["background"]."\"";
				$vidtag .= " poster=\"".$a["poster"]."\"";
				$vidtag .= " loop></video>";
				$retval = $vidtag.$retval;
			} else {
				$bg = $a["background"];
				$bg = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $bg);
				if (isset($a["fixed"]) && $a["fixed"]=="true") {
					$class .= " mlt-background-fixed";
				} else {
					$class .= " mlt-background-cover";
				}
				$imgtag = "<img class=\"mlt-responsive-background\"";
				$imgtag .= " data-original-image=\"".$bg."\"";
				$imgtag .= " src=\"/responsive-media/?f=".$bg."&amp;type=generic&amp;size=0&amp;scale=1x\"";
				$imgtag .= " />";
				$retval = $imgtag.$retval;
			}
		}
		$retval = "<div class=\"".$class."\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("shortcodename", "ShortcodeFunction");
	$GLOBALS["MLTS_fix_codes"][]="shortcodename";
}

*/


if (!function_exists("MSU_HomepageHero")) {
	function MSU_HomepageHero($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("background"=>"", "alt"=>"", "showlinks"=>"true", "label"=>"", "short"=>"false", "video"=>"", "av1"=>""), $atts, "homepagehero");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-homepage-hero";
		if (!empty($a["short"]) && $a["short"]=="true") {
			$class .= " short";
		}
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		$imgID = null;

		// build HTML
		$retval = "";

		// if there's no background, try to get the page thumbnail
		if (empty($a["background"])) {
			$a["background"] = get_the_post_thumbnail_url(null, "original");
		}

		// if the user asked for a video, let's make sure the file exists
		if (!empty($a["video"])) {
			$a["video"] = preg_replace("/^(.+)\\/wp-content\\//i", "/wp-content/", $a["video"]);
			if (!file_exists($_SERVER["DOCUMENT_ROOT"].$a["video"])) {
				$a["video"] = "";
			}
		}

		// ditto an av1 alternative 
		if (!empty($a["av1"])) {
			$a["av1"] = preg_replace("/^(.+)\\/wp-content\\//i", "/wp-content/", $a["av1"]);
			if (!file_exists($_SERVER["DOCUMENT_ROOT"].$a["av1"])) {
				$a["av1"] = "";
			}
		}

		if (!empty($a["video"])) {
			// we still want to get the $imgtag so that we can set background on div.image-wrapper below
			if (!empty($a["background"])) {
				$imgtag = getResponsiveImageTag($a["background"], true);
			}
			$found = preg_match("/data-original-image=\\\"([^\\\"]+)\\\"/i", $imgtag, $match);
			$found2 = preg_match("/alt=\\\"([^\\\"]+)\\\"/i", $imgtag, $match2);
			$retval = sprintf("<div class=\"prpl-desktop-only-video\" data-src=\"%s\" data-poster=\"%s\" data-alt=\"%s\" data-av1=\"%s\"></div>%s",
				$a["video"], $found?$match[1]:"",$found2?$match2[1]:"", $a["av1"], $retval);
		} else if (!empty($a["background"])) {
			$imgtag = getResponsiveImageTag($a["background"], true);

			if (isset($a["fixed"]) && $a["fixed"]=="true") {
				$class .= " mlt-background-fixed";
			} else {
				$class .= " mlt-background-cover";
			}

			$retval = $imgtag.$retval;
		}
		$retval .= "<h1 id=\"content-start\">".htmlentities(empty($a["label"])?get_option("blogname"):$a["label"])."</h1>";

		// see if we can find the URL of the background image and pull it in
		$found = preg_match("/src=\\\"([^\\\"]+)\\\"/i", $imgtag, $match);
		if ($found) {
			$retval = sprintf("<div class=\"image-wrapper\" style=\"background-image: url(%s);\">%s</div>", htmlentities($match[1]), $retval);
		} else {
			$retval = sprintf("<div class=\"image-wrapper\" >%s</div>", $retval);
		}

		if ($a["showlinks"]=="true") {
			$retval .= "<div class=\"hero-footer\">".$content."</div>";
		}

		$retval = "<div class=\"".$class."\">".$retval."</div>";
		
		return $retval;
	}

	add_shortcode("homepagehero", "MSU_HomepageHero");
}

if (!function_exists("MSU_Button")) {
	function MSU_Button($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>""), $atts, "button");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-button".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<span class=\"".$class."\">".$content."</span>";
		
		
		return $retval;
	}

	add_shortcode("button", "MSU_Button");
}

if (!function_exists("MSU_HomepageBand")) {
	function MSU_HomepageBand($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"", "image"=>"", "align"=>"", "scalable"=>"false", "alt"=>""), $atts, "homepageband");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-band".(empty($a["class"])?"":" ".$a["class"]);
		if (!empty($a["scalable"]) && strtolower($a["scalable"])=="true") {
			$class .= " scalable";
		}
		
		// get content
		$content = do_shortcode($content);
		$content = force_balance_tags(wpautop($content));
		$content = str_replace("<p></p>", "", $content);
		
		$imgID = null;
		$b64thumbnail = null;

		// build HTML
		$retval = "";
		if (!empty($a["image"])) {
			// figure out if the image floats right or left
			if (empty($a["align"]) || strtolower($a["align"])=="left") {
				$class .= " image-right";
			} else {
				$class .= " image-left";
			}

			$imgtag = "";
			if (preg_match('/youtube\.com/i', $a["image"]) == 1 ||
				preg_match('/youtu\.be/i', $a["image"])) {
				$imgtag = wp_oembed_get($a["image"]);
			} else {
				$imgtag = getResponsiveImageTag($a["image"], false);
			}

			$retval = "<div class=\"image-wrapper\">".$imgtag."</div>";
		} else {
			$class .= " no-margin";
		}
		$retval .= "<div class=\"text-content\">".$content."</div>";
		$retval = "<div class=\"".$class."\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("homepageband", "MSU_HomepageBand");
	$GLOBALS["MLTS_fix_codes"][]="homepageband";
}

if (!function_exists("MSU_Band")) {
	function MSU_Band($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>""), $atts, "band");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-band".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"prpl-band-content\">".$content."</div>";
		$retval = "<div class=\"".$class."\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("band", "MSU_Band");
	$GLOBALS["MLTS_fix_codes"][]="band";
}


if (!function_exists("MSU_Accordion")) {
	function MSU_Accordion($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"", "label"=>"", "open"=>"false"), $atts, "accordion");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-drawer".(empty($a["class"])?"":" ".$a["label"]);
		if (isset($a["open"]) && strtolower($a["open"])=="true") {
			$class .= " open";
		}
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		$a["label"] = html_entity_decode($a["label"]);

		// build HTML
		$retval = "";
		$retval .= "<div class=\"prpl-drawer-header\">".htmlentities($a["label"], ENT_COMPAT|ENT_QUOTES|ENT_HTML5, "UTF-8")."</div>";
		$retval .= "<div class=\"prpl-drawer-content\">".$content."</div>";
		$retval = "<div class=\"".$class."\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("accordion", "MSU_Accordion");
	$GLOBALS["MLTS_fix_codes"][]="accordion";
	add_shortcode("drawer", "MSU_Accordion");
	$GLOBALS["MLTS_fix_codes"][]="drawer";
}


if (!function_exists("MSU_PreHeading")) {
	function MSU_PreHeading($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>""), $atts, "prehead");
		
		// build the tag's class name as default + $a["class"]
		$class = "pre-heading".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<span class=\"".$class."\">".$content."</span><br />";
		
		
		return $retval;
	}

	add_shortcode("prehead", "MSU_PreHeading");
}


if (!function_exists("MSU_Tab")) {
	function MSU_Tab($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("label"=>"Tab Label"), $atts, "tab");
		
		// get label
		$label = $a["label"];
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<h2>".htmlspecialchars($label, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8")."</h2>";
		$retval .= $content;
		$retval = "<div class=\"tab-content\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("tab", "MSU_Tab");
	$GLOBALS["MLTS_fix_codes"][]="tab";
}

if (!function_exists("MSU_TabGroup")) {
	function MSU_TabGroup($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "tabgroup");
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"tab-group\">".$content."</div>";
		
		return $retval;
	}

	add_shortcode("tabgroup", "MSU_TabGroup");
	$GLOBALS["MLTS_fix_codes"][]="tabgroup";
}


if (!function_exists("MSU_RowShortcode")) {
	function MSU_RowShortcode($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>""), $atts, "row");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-row".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"".$class."\">".$content."</div>";
		
		
		return $retval;
	}

	add_shortcode("row", "MSU_RowShortcode");
	$GLOBALS["MLTS_fix_codes"][]="row";
}

if (!function_exists("MSU_ColumnShortcode")) {
	function MSU_ColumnShortcode($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>""), $atts, "column");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-column".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"".$class."\">".$content."</div>";
		
		
		return $retval;
	}

	add_shortcode("column", "MSU_ColumnShortcode");
	$GLOBALS["MLTS_fix_codes"][]="column";
}

if (!function_exists( 'atg_figure_caption' )) {
	function atg_figure_caption( $output, $attr, $content ) {

		/* We're not worried abut captions in feeds, so just return the output here. */
		if ( is_feed() ) { return $output; }

		/* Set up the default arguments. */
		$defaults = array(
			'id' => '',
			'align' => 'alignnone',
			'width' => '',
			'caption' => '',
			'bordered' => ''
		);

		/* Merge the defaults with user input. */
		$attr = shortcode_atts( $defaults, $attr );

		/* Set up the attributes for the caption <figure>. */
		$attributes = ( !empty( $attr['id'] ) ? ' id="' . esc_attr( $attr['id'] ) . '"' : '' );
		$attributes .= ' class="responsive-image-holder wp-caption ' . esc_attr( $attr['align'] ) . '"';

		/* Open the caption <figure>. */
		$output = '';

		/* Allow shortcodes for the content the caption was created for. */
		// $output .= do_shortcode( $content );
		$matches = array();
		if (@preg_match('/< *img[^>]*src *= *["\']?([^"\']*)/i', $content, $matches)) {
			// wp_enqueue_script("picturefill");

			// see if the URL suggests that the image comes from another site in this instance
			$imageSiteID = mpGetImageSiteIDFromURL($matches[1]);
			$currentSiteID = get_current_blog_id();
			if ($imageSiteID != false) switch_to_blog($imageSiteID);

			$thumbID = mpGetIDFromURL($matches[1]);
			$ImageURL = wp_get_attachment_image_src($thumbID, "full");
			$ImageURL = $ImageURL[0];

			// For SVG or GIF images, we should assume that the editor does not want the images resized and saved as JPEG. 
			// This will preserve vectors in SVG and animation in GIF. 
			if (preg_match("/svg\$/i", $ImageURL)) {
				$output .= wp_get_attachment_image($thumbID, "full");
			} else if (preg_match("/gif\$/i", $ImageURL)) {
				$output .= wp_get_attachment_image($thumbID, "full");
			} else {
				$output .= getResponsiveImageTag($matches[1], false); // send the original match in since this function does its own scrubbing
			}

			// boy this is pretty hacky
			if ($attr["bordered"] == "true") {
				$output = str_replace("class=\"", "class=\"bordered ", $output);
			}

			// check to see if there's a link tag before the image
			$imgpos = mb_stripos($content, "<img ");
			$apos = mb_stripos($content, "<a ");
			if ($apos !== false && $imgpos !== false && $apos<$imgpos) {
				// wrap get the original opening A tag and wrap it around the IMG tag we generated above
				$apos2 = mb_stripos($content, ">", $apos+1);
				if ($apos2 !== false) {
					$output = mb_substr($content, $apos, $apos2-$apos+1).$output."</a>";
				}
			}

			// switch back to the original site ID when we're done
			switch_to_blog($currentSiteID);
			
		} else {
			$output .= $content;
		}

		/* Append the caption text. */
		if (isset($attr['caption'])) {
			$s = $attr["caption"];
			$s = preg_replace('/^[\pZ\pC]+|[\pZ\pC]+$/u','',$s); // unicode trim
			if (!empty($s)) {
				$output .= '<figcaption class="wp-caption-text">' . $attr['caption'] . '</figcaption>';
			}
		}

		/* Wrap the caption in  <figure> */
		$output = '<figure' . $attributes .'>'.$output.'</figure>';

		/* Return the formatted, clean figure & figcaption. */
		return $output;
	}
}
add_filter( 'img_caption_shortcode', 'atg_figure_caption', 10, 3 );
$GLOBALS["MLTS_fix_codes"][]="caption";
function MSU_Image ($atts, $content) {
	return atg_figure_caption("", $atts, $content);
}
add_shortcode("image", "MSU_Image");
$GLOBALS["MLTS_fix_codes"][]="image";

/*
BUG FIX FOR PHP 8 AND NEWER
If an empty string gets passed to img_caption_shortcode, it just fucking breaks.
So, this function will supersede img_caption_shortcode, fix the input value,
then call img_caption_shortcode with the corrected value.
*/
function img_caption_shortcode_supporting_empty( $attr, $content = null ) {
	if ( $attr == '' ) {
		$attr = array();
	}

	return img_caption_shortcode($attr, $content);
}
remove_shortcode('caption');
add_shortcode('caption', 'img_caption_shortcode_supporting_empty');



if (!function_exists("MSU_StepGroup")) {
	function MSU_StepGroup($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "stepgroup");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-step-group";
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"".$class."\">".$content."</div>";
		
		
		return $retval;
	}

	add_shortcode("stepgroup", "MSU_StepGroup");
	$GLOBALS["MLTS_fix_codes"][]="stepgroup";
}

if (!function_exists("MSU_Step")) {
	function MSU_Step($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("number"=>""), $atts, "step");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-step";
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		$content = str_replace("<p></p>", "", $content);
		
		// build number area
		$numberArea = "<span class=\"label-part\">Step</span>";
		$numberArea .= " <span class=\"number-part\">".intval($a["number"])."</span>";
		$numberArea = "<div class=\"prpl-step-number\">".$numberArea."</div>";

		// build HTML
		$contentArea = "<div class=\"prpl-step-content\">".$content."</div>";
		
		$retval = "<div class=\"".$class."\">".$numberArea."\n".$contentArea."</div>";
		
		
		return $retval;
	}

	add_shortcode("step", "MSU_Step");
	$GLOBALS["MLTS_fix_codes"][]="step";
}

if (!function_exists("MSU_ButtonRow")) {
	function MSU_ButtonRow($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "buttonrow");
		
		// build the tag's class name as default + $a["class"]
		$class = "mlt-band".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<p class=\"prpl-button-row\">".$content."</p>";
		
		return $retval;
	}

	add_shortcode("buttonrow", "MSU_ButtonRow");
	$GLOBALS["MLTS_fix_codes"][]="buttonrow";
}

$GLOBALS["MSUHomepageCarouselCount"] = 0;

if (!function_exists("MSU_HomepageHeroCarousel")) {
	function MSU_HomepageHeroCarousel($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("campaign"=>""), $atts, "homepageherocarousel");
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
	
		$tmp = "<h1 class=\"a11y-label\" id=\"content-start\">".get_the_title()."</h1>";
		$tmp .= "<div class=\"prpl-homepage-hero-carousel\" ".($a["campaign"]?" data-utm-campaign=\"".htmlspecialchars($a["campaign"])."\"":"").">";
		$tmp .= '<div class="previous-nav"><a href="javascript: ;"><span class="a11y-label">Previous Slide</span><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30"><path fill="#000" d="M19.01 25.607l1.415-1.414-8.712-8.71 8.712-8.712-1.414-1.414L8.9 15.466l.048.05-.014.016"/></svg></a></div>';
		$tmp .= "<div class=\"active-region\" role=\"region\" aria-live=\"polite\" aria-label=\"Slideshow\">";
		$tmp .= $content;
		$tmp .= "</div>";
		$tmp .= '<div class="next-nav"><a href="javascript: ;" label="Next Slide"><span class="a11y-label">Next Slide</span><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 30 30"><path fill="#000" d="M10.314 5.356L8.9 6.77l8.71 8.71-8.71 8.713 1.414 1.414 10.11-10.11-.048-.05.015-.015"/></svg></a></div>';
		$tmp .= "</div>";

		return $tmp;
	}

	add_shortcode("homepageherocarousel", "MSU_HomepageHeroCarousel");
	$GLOBALS["MLTS_fix_codes"][]="homepageherocarousel";
}

if (!function_exists("MSU_HomepageHeroCarouselItem")) {
	function MSU_HomepageHeroCarouselItem($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("background"=>"", "poster"=>"", "label"=>"Feature", "cta"=>"Read More", "link"=>"", "starttime"=>"", "endtime"=>""), $atts, "homepageherocarouselitem");

		// check start time
		$now = intval(date("U"));
		// echo sprintf("now: %s\n", date("Y-m-d H:i:s", $now));
		if (isset($a["starttime"]) && $a["starttime"]!="") {
			$tmpTime = @wp_strtotime($a["starttime"]);
			// echo sprintf("starttime: %s\n", date("Y-m-d H:i:s", intval($tmpTime)));
			if ($tmpTime) {
				$tmpTime = intval($tmpTime);
				if ($tmpTime > $now) return "";
			}
		}

		if (isset($a["endtime"]) && $a["endtime"]!="") {
			$tmpTime = @wp_strtotime($a["endtime"]);
			// echo sprintf("endtime: %s\n", date("Y-m-d H:i:s", intval($tmpTime)));
			if ($tmpTime) {
				$tmpTime = intval($tmpTime);
				if ($tmpTime <= $now) return "";
			}
		}
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);

		$imgID = null;
		
		// build HTML
		$retval = "";
		$id = "HomepageCarouselItemText".$GLOBALS["MSUHomepageCarouselCount"];
		$GLOBALS["MSUHomepageCarouselCount"]++;
		if (!empty($a["background"])) {
			if (preg_match("/\\.mp4$/i", $a["background"])) {
				$class .= " mlt-band-video-background";
				$vidtag = "<video class=\"mlt-background-video\"";
				$vidtag .= " src=\"".$a["background"]."\"";
				$vidtag .= " poster=\"".$a["poster"]."\"";
				$vidtag .= " loop></video>";
				$retval .= "<div class=\"image-wrapper\">".$vidtag."</div>";
			} else {
				$imgtag = getResponsiveImageTag($a["background"],true);

				$class = "";
				if (isset($a["fixed"]) && $a["fixed"]=="true") {
					$class .= " mlt-background-fixed";
				} else {
					$class .= " mlt-background-cover";
				}

				// see if we can find the URL of the background image and pull it in
				$found = preg_match("/src=\\\"([^\\\"]+)\\\"/i", $imgtag, $match);
				if ($found) {
					$retval = sprintf("<div class=\"image-wrapper\" style=\"background-image: url(%s);\">%s</div>", htmlentities($match[1]), $imgtag);
				} else {
					$retval = sprintf("<div class=\"image-wrapper\" >%s</div>", $imgtag);
				}
			}
		}


		$contentParse = new DOMDocument("1.0", "UTF-8");
		$contentParse->loadHTML("<!DOCTYPE html><head><meta http-equiv='Content-type' content='text/html; charset=utf-8'></head><body>".$content."</body></html>");

		$retval .= "<div class=\"content-screen\">";
		$retval .= "<div class=\"label\"><span>".htmlspecialchars($a["label"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8")."</span></div>";
		$retval .= "<div class=\"message\" id=\"".htmlspecialchars($id)."\">".$content."</div>";
		$retval .= "<div class=\"cta\"><p><span class=\"prpl-button full-width\"><a href=\"".htmlspecialchars($a["link"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8")."\" >";
		$retval .= htmlspecialchars($a["cta"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8")."<span class='a11y-label'>:".$contentParse->textContent."</span></a></span></p></div>";
		$retval .= "</div>";
		
		$retval = "<div class=\"homepage-carousel-item\" aria-live='off' aria-hidden='true' tabindex='-1'>".$retval."</div>";
		
		return $retval;
	}

	add_shortcode("homepageherocarouselitem", "MSU_HomepageHeroCarouselItem");
	$GLOBALS["MLTS_fix_codes"][]="homepageherocarouselitem";
}

if (!function_exists("MSU_MasonrySet")) {
	function MSU_MasonrySet($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("campaign"=>""), $atts, "masonryset");
		
		// build the tag's class name as default + $a["class"]
		$class = "masonry-set";
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = "<div class=\"".$class."\"".($a["campaign"]?" data-utm-campaign=\"".htmlspecialchars($a["campaign"])."\"":"").">".$content."</div>";
		
		
		return $retval;
	}

	add_shortcode("masonryset", "MSU_MasonrySet");
	$GLOBALS["MLTS_fix_codes"][]="masonryset";
}

if (!function_exists("MSU_MasonryTile")) {
	function MSU_MasonryTile($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"", "background"=>"", "starttime"=>"", "endtime"=>""), $atts, "masonrytile");
		
		// check start time
		$now = intval(date("U"));
		// echo sprintf("now: %s\n", date("Y-m-d H:i:s", $now));
		if (isset($a["starttime"]) && $a["starttime"]!="") {
			$tmpTime = @wp_strtotime($a["starttime"]);
			// echo sprintf("starttime: %s\n", date("Y-m-d H:i:s", intval($tmpTime)));
			if ($tmpTime) {
				$tmpTime = intval($tmpTime);
				if ($tmpTime > $now) return "";
			}
		}

		if (isset($a["endtime"]) && $a["endtime"]!="") {
			$tmpTime = @wp_strtotime($a["endtime"]);
			// echo sprintf("endtime: %s\n", date("Y-m-d H:i:s", intval($tmpTime)));
			if ($tmpTime) {
				$tmpTime = intval($tmpTime);
				if ($tmpTime <= $now) return "";
			}
		}
		
		// build the tag's class name as default + $a["class"]
		$class = "tile".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		$imgID = null;

		// build HTML
		$retval = "<div class=\"content-holder\">".$content."</div>";
		if (!empty($a["background"])) {
			if (isset($a["fixed"]) && $a["fixed"]=="true") {
				$class .= " mlt-background-fixed";
			} else {
				$class .= " mlt-background-cover";
			}
			$imgtag = getResponsiveImageTag($a["background"], true);

			// see if we can find the URL of the background image and pull it in
			$found = preg_match("/src=\\\"([^\\\"]+)\\\"/i", $imgtag, $match);
			if ($found) {
				$imgtag = sprintf("<div class=\"background-holder\" style=\"background-image: url(%s);\">%s</div>", htmlentities($match[1]), $imgtag);
			} else {
				$imgtag = sprintf("<div class=\"background-holder\" >%s</div>", $imgtag);
			}

			$retval = $imgtag.$retval;
		}
		$retval = "<div class=\"".$class."\">".$retval."</div>";		
		
		return $retval;
	}

	add_shortcode("masonrytile", "MSU_MasonryTile");
	$GLOBALS["MLTS_fix_codes"][]="masonrytile";
}

if (!function_exists("MSU_MajorsFilter")) {
	function MSU_MajorsFilter($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("default"=>""), $atts, "majorsfilter");

		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);

		$options = array(
			"all" => "All Types",
			"Bachelor's" => "Bachelor's Degrees",
			"Minor" => "Undergraduate Minor",
			"Master's" => "Master's Degrees",
			"Doctorate" => "Doctoral Programs",
			"Certificate" => "Certificate Programs",
			"Online" => "Online Programs",
		);

		if (!isset($a["default"]) || empty($a["default"])) $a["default"] = "all";


		ob_start();
		?>
		<div class="majors-filter">
			<div class="search-area">
				<?PHP echo $content; ?>
				<div class="prpl-row" role="region" aria-label="Academic Finder Form Controls">
					<div class="prpl-column one-third">
						<label>Program Name: <span class="input-wrapper"><input type="text" class="major-name" aria-controls="MajorsFilterResultCount MajorsFilterResults"/></span></label>
						<div class="result-count" id="MajorsFilterResultCount" aria-live="polite" role="region" aria-label="Academic Program Result Count"></div>
					</div>
					<div class="prpl-column one-third">
						<label>Type: <span class="select-wrapper"><select class="major-type" aria-controls="MajorsFilterResultCount MajorsFilterResults">
							<?PHP 
								foreach ($options as $key=>$val) {
									echo sprintf("<option value=\"%s\" %s>%s</option>", 
										$key, mb_strtolower($a["default"])==mb_strtolower($key)?"selected":"", $val);
								}
							?>
						</select></span></label>
					</div>
					<div class="prpl-column one-third desktop-only" style="text-align: right;">
						<div class="prpl-row">
							<div class="prpl-column one-half" style="text-align: center"><strong class="or-label">- OR - </strong></div>
							<div class="prpl-column one-half"><span class="prpl-button full-width"><a href="javascript: ;" class="randomizer">Random Program</a></span></div>
						</div>
					</div>
				</div>
			</div>
			<div class="results-area" id="MajorsFilterResults" aria-label="Academic Finder Results" role="region" aria-live="off"></div>
		</div>
		<?PHP 
		$retval = ob_get_contents();
		ob_end_clean();
		
		
		return $retval;
	}

	add_shortcode("majorsfilter", "MSU_MajorsFilter");
	$GLOBALS["MLTS_fix_codes"][]="majorsfilter";
}

if (!function_exists("MSU_HomepageHawkeye")) {
	function MSU_HomepageHawkeye($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "homepagehawkeye");
		
		ob_start();

		$background_url = get_stylesheet_directory_uri()."/campus-aerial-blurred.jpg";
		$background_url = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $background_url);
		?>
		<div class="prpl-band scalable homepage-hawkeye" style="background-image: url(/responsive-media/cache<?PHP echo $background_url; ?>.0.1x.generic.jpg);">
			<?PHP 
				$tmp = getResponsiveImageTag($background_url, true);
				$tmp = str_replace("<img", "<img alt='Aerial photo of college hall.'", $tmp);
				echo $tmp;
			?>
			<div class="text-content">
				<div class="search-area">
					<h2><span class="pre-heading">Hawkeye Search</span><br />What can we help you find today?</h2>
					<p>Our curated index of pages, people, majors, minors and locations will help you find exactly what you’re looking for.</p>
					<p class="input-label"><label for="HomepageHawkeyeInput">Search:</label></p>
					<div class="input-wrapper"><input type="text" value="" name="q" aria-controls="HomepageHawkeyeResultCount HomepageHawkeyeResultOutput" id="HomepageHawkeyeInput"/></div>
					<p class="search-toggles" role="region" aria-label="Hawkeye Search Filters"><span aria-hidden="true">Filter:</span> </p>
				</div>
				<div class="results-area" id="HomepageHawkeyeResults">
					<p class="result-count" id="HomepageHawkeyeResultCount" aria-live="polite" role="region" aria-label="Homepage Search Result Count"></p>
					<div class="result-output" id="HomepageHawkeyeResultOutput" aria-label="Hawkeye Results" role="region" aria-live="off"></div>
				</div>
			</div>
		</div>

		<?PHP 

		$retval = ob_get_contents();
		ob_end_clean();		

		wp_enqueue_style("homepage-hawkeye-icons");
		
		return $retval;
	}

	add_shortcode("homepagehawkeye", "MSU_HomepageHawkeye");
	$GLOBALS["MLTS_fix_codes"][]="homepagehawkeye";
}



if (!function_exists("MSU_RelatedPrograms")) {
	function MSU_RelatedPrograms($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "relatedprograms");
		
		// build HTML
		$retval = "";

		$matches = null;
		preg_match_all("/href=[\"']([^\"']+)[\"']/i", $content, $matches);

		if (isset($matches[1]) && is_array($matches[1])) {
			foreach ($matches[1] as $match) {
				$MatchID = url_to_postid($match);
				if ($MatchID) {
					$MatchPost = get_post($MatchID);
					$ThumbnailID = get_post_thumbnail_id($MatchID);
					$ThumbnailURL = wp_get_attachment_image_url($ThumbnailID, "original");

					$retval .= "<li>";
					$retval .= "<span class='image-wrapper'>";
					$retval .= getResponsiveImageTag($ThumbnailURL, true);
					$retval .= "</span>";
					$retval .= sprintf("<p><a href='%s'>%s</a></p>",
						htmlspecialchars($match, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8"),
						htmlspecialchars($MatchPost->post_title, ENT_COMPAT|ENT_HTML5|ENT_QUOTES, "UTF-8"));
					$retval .= "</li>";

				}
			}
			$retval = "<ul class=\"related-programs\">".$retval."</ul>";
		} else {
			$retval = $content;
		}
		
		return $retval;
	}

	add_shortcode("relatedprograms", "MSU_RelatedPrograms");
	/*
	$GLOBALS["MLTS_fix_codes"][]="relatedprograms";
	*/
}


if (!function_exists("MSU_ContactInfoShortcode")) {
	function MSU_ContactInfoShortcode($atts, $content=null) {
		// get attributes
		$a = shortcode_atts(array("department"=>"Us", "location"=>null, "mapurl"=>null, "phone"=>null, "extension"=>null, "fax"=>null, "text"=>null, "email"=>null), $atts, "contactinfo");

		// validate phone
		$c = "phone"; // field we're checking - this way we can copy/paste and do fax
		if ($a[$c]) {
			$a[$c] = preg_replace("/[^0-9]/i","", $a[$c]);
			if (strlen($a[$c])!=10) {
				$a[$c] = null;
			} else {
				$a[$c] = sprintf("%s-%s-%s", substr($a[$c], 0, 3), substr($a[$c], 3, 3), substr($a[$c], 6, 4));
			}
		}
		$c = "fax";
		if ($a[$c]) {
			$a[$c] = preg_replace("/[^0-9]/i","", $a[$c]);
			if (strlen($a[$c])!=10) {
				$a[$c] = null;
			} else {
				$a[$c] = sprintf("%s-%s-%s", substr($a[$c], 0, 3), substr($a[$c], 3, 3), substr($a[$c], 6, 4));
			}
		}
		$c = "text";
		if ($a[$c]) {
			$a[$c] = preg_replace("/[^0-9]/i","", $a[$c]);
			if (strlen($a[$c])!=10) {
				$a[$c] = null;
			} else {
				$a[$c] = sprintf("%s-%s-%s", substr($a[$c], 0, 3), substr($a[$c], 3, 3), substr($a[$c], 6, 4));
			}
		}

		// validate email
		if ($a["email"]) {
			if (!preg_match("/^[a-zA-Z0-9_\.-]+@(mail\.)?montclair\.edu/", $a["email"]) && !preg_match("/^[a-zA-Z0-9_\.-]+@bloomfield\.edu/", $a["email"])) {
				$a["email"] = null;
			}
		}

		// if there's no valid information then exit 
		if (!($a["location"]||$a["phone"]||$a["fax"]||$a["email"]||$a["text"])) {
			return "";
		}

		$a["department"] = htmlspecialchars_decode($a["department"]);
		$a["location"] = htmlspecialchars_decode($a["location"]);
		$a["extension"] = preg_replace("/[^0-9]/", "", $a["extension"]);
		
		// build HTML
		$retval = "<div class=\"contact-info\">";
		$retval .= "<div class=\"contact-info-header\">";
		$retval .= "<span>Contact ".htmlspecialchars($a["department"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."</span>";
		$retval .= "</div>";
		$retval .= "<div class=\"contact-info-body\">";
		$retval .= "<dl>";

		if ($a["location"]) {
			$retval .= "<div class=\"contact-info-group\">";
			$retval .= "<dt>Location:</dt>";
			$retval .= "<dd>".htmlspecialchars($a["location"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8');
			if ($a["mapurl"]) {
				$retval .= " <a href=\"".htmlspecialchars($a["mapurl"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8')."\" class=\"contact-info-map-link\" target=\"_blank\">View on Map</a>";
			}
			$retval .= "</dd>";
			$retval .= "</div>";
		}

		if ($a["phone"]) {
			$phoneLink = "tel:".$a["phone"].(empty($a["extension"])?"":", ".$a["extension"]);
			$phoneLabel = $a["phone"].(empty($a["extension"])?"":", Ext: ".$a["extension"]);
			$retval .= "<div class=\"contact-info-group\">";
			$retval .= "<dt>Phone:</dt>";
			$retval .= "<dd><a href=\"".$phoneLink."\" class=\"a11y-phone-number\">".$phoneLabel."</a></dd>";
			$retval .= "</div>";
		}

		if ($a["text"]) {
			$retval .= "<div class=\"contact-info-group\">";
			$retval .= "<dt>Text:</dt>";
			$retval .= sprintf("<dd><a href=\"sms:%s\">%s</a></dd>", $a["text"], $a["text"]);
			$retval .= "</div>";
		}

		if ($a["fax"]) {
			$retval .= "<div class=\"contact-info-group\">";
			$retval .= "<dt>Fax:</dt>";
			$retval .= "<dd>".$a["fax"]."</dd>";
			$retval .= "</div>";
		}

		if ($a["email"]) {
			$retval .= "<div class=\"contact-info-group\">";
			$retval .= "<dt>Email:</dt>";
			$retval .= "<dd><a href=\"mailto:".$a["email"]."\">".$a["email"]."</a></dd>";
			$retval .= "</div>";
		}

		$retval .= "</dl>";
		$retval .= "</div>";
		$retval .= "</div>";
		
		return $retval;
	}

	add_shortcode("contactinfo", "MSU_ContactInfoShortcode");
	// $GLOBALS["MLTS_fix_codes"][]="contactinfo";
}


if (!function_exists("MSU_SmallBandShortcode")) {
	function MSU_SmallBandShortcode($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"", "image"=>"", "align"=>"", "scalable"=>"false", "alt"=>""), $atts, "smallband");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-band-small".(empty($a["class"])?"":" ".$a["class"]);
		if (!empty($a["scalable"]) && strtolower($a["scalable"])=="true") {
			$class .= " scalable";
		}
		
		// get content
		$content = do_shortcode($content);
		$content = force_balance_tags(wpautop($content));
		$content = str_replace("<p></p>", "", $content);
		
		$imgID = null;
		$b64thumbnail = null;

		// build HTML
		$retval = "";
		if (!empty($a["image"])) {
			// figure out if the image floats right or left
			if (empty($a["align"]) || strtolower($a["align"])=="left") {
				$class .= " image-right";
			} else {
				$class .= " image-left";
			}

			$imgtag = getResponsiveImageTag($a["image"], false);

			$retval = "<div class=\"image-wrapper\">".$imgtag."</div>";
		} else {
			$class .= " no-margin";
		}
		$retval .= "<div class=\"text-content\">".$content."</div>";
		$retval = "<div class=\"".$class."\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("smallband", "MSU_SmallBandShortcode");
	$GLOBALS["MLTS_fix_codes"][]="smallband";
}


if (!function_exists("MSU_PhotoGalleryShortcode")) {

	function MSU_PhotoGalleryInvalidateCache($inPostID) {
		global $wpdb;
		$sql = "SELECT `option_name` AS `name`, `option_value` AS `value`
				FROM  $wpdb->options
				WHERE `option_name` LIKE '_transient_msu_pg_".intval($inPostID)."%'
				ORDER BY `option_name`";
		$results = $wpdb->get_results( $sql );

		$newsFeeds = array();
		foreach ($results as $r) {
			$newsFeeds []= mb_substr($r->name, mb_strlen("_transient_"));
		}

		foreach ($newsFeeds as $nf) {
			delete_transient($nf);
		}
	}

	function MSU_PhotoGallery_TransitionPostStatus ($new_status, $old_status, $post) {
		if ("publish" === $new_status) {
			MSU_PhotoGalleryInvalidateCache($post->ID);
		}
	}

	function MSU_PhotoGallery_PostUpdated ($post_id, $new_post, $old_post) {
		if ($new_post->post_type == "post") {
			MSU_PhotoGalleryInvalidateCache($post_id);
		}
	}

	add_action('transition_post_status', 'MSU_PhotoGallery_TransitionPostStatus', 10, 3);
	add_action('post_updated', "MSU_PhotoGallery_PostUpdated", 10, 3);


	function MSU_PhotoGalleryShortcode($atts, $content) {
		if (!isset($GLOBALS["MSU_PhotoGalleryOrdinal"])) {
			$GLOBALS["MSU_PhotoGalleryOrdinal"] = 0;
		}
		$transientName = sprintf("msu_pg_%d_%d", get_the_ID(), $GLOBALS["MSU_PhotoGalleryOrdinal"]);

		$retval = false;
		if (!is_preview()) $retval = get_transient($transientName);

		if (!$retval) {
			// get attributes
			$a = shortcode_atts(array(), $atts, "photogallery");

			// get content
			$content = force_balance_tags($content);
			$content = str_replace("<p></p>", "", $content);
			$content = do_shortcode($content);
			
			// build HTML
			$retval = "<div class=\"prpl-photo-gallery\">";
			$retval .= "<p class=\"a11y-label\">Click on an image below to enlarge photo.</p>";
			$retval .= "<div class=\"previous-button\"><a href=\"javascript: ;\">Previous</a></div><div class=\"next-button\"><a href=\"javascript: ;\">Next</a></div>";
			$retval .= $content."</div>";
			if (!is_preview()) set_transient($transientName, $retval);
		} else {
			$retval .= "<!-- cached result -->";
		}

		$GLOBALS["MSU_PhotoGalleryOrdinal"]++;
		return $retval;
	}

	add_shortcode("photogallery", "MSU_PhotoGalleryShortcode");
	$GLOBALS["MLTS_fix_codes"][]="photogallery";
}

if (!function_exists( 'MSU_PhotoGalleryItemShortcode' )) {
	function MSU_PhotoGalleryItemShortcode($attr, $content ) {
		$output = "";

		/* We're not worried abut captions in feeds, so just return the output here. */
		if ( is_feed() ) { return $output; }

		/* Set up the default arguments. */
		$defaults = array(
			'id' => '',
			'caption' => '',
			'download' => 'false'
		);

		/* Merge the defaults with user input. */
		$attr = shortcode_atts( $defaults, $attr, "photogalleryitem");

		/* Set up the attributes for the caption <figure>. */
		$attributes = ( !empty( $attr['id'] ) ? ' id="' . esc_attr( $attr['id'] ) . '"' : '' );
		$attributes .= ' class="gallery-item"';

		/* Open the caption <figure>. */
		$output = '<div' . $attributes .'>';

		/* Allow shortcodes for the content the caption was created for. */
		// $output .= do_shortcode( $content );
		$matches = array();
		if (@preg_match('/< *img[^>]*src *= *["\']?([^"\']*)/i', $content, $matches)) {

			$thumbID = mpGetIDFromURL($matches[1]);
			$ImageURL = wp_get_attachment_image_src($thumbID, "full");
			$ImageURL = $ImageURL[0];

			$imgtag = getResponsiveImageTag($ImageURL, true, true);

			// see if we can find the URL of the background image and pull it in
			$found = preg_match("/src=\\\"([^\\\"]+)\\\"/i", $imgtag, $match);
			if ($found) {
				$imgtag = sprintf("<div class=\"photo-holder\" style=\"background-image: url(%s);\">%s</div>", htmlentities($match[1]), $imgtag);
			} else {
				$imgtag = sprintf("<div class=\"photo-holder\" >%s</div>", $imgtag);
			}
			
			$output .= $imgtag;
		} else {
			$output .= $content;
		}

		$DLHTML = "<p class='prpl-button-row'><span class='prpl-button ghost-white'><a href=\"".$ImageURL."\" target=\"_blank\">Download Image</a></span></p>";

		/* Append the caption text. */
		if ($attr['caption'] !== '') {
			$output .= '<div class="caption">' . $attr['caption'] . ($attr["download"]=="true"?$DLHTML:"").'</div>';
		} else {
			// excise the image tag from content and then make that the caption
			$imgStart = stripos($content, "<img");
			$imgEnd = stripos($content, "/>", $imgStart);
			$caption = substr($content, 0, $imgStart).substr($content, $imgEnd+2);
			$output .= "<div class='caption'>".$caption.($attr["download"]=="true"?$DLHTML:"")."</div>";
		}
		$output .= "<div class='close-button'><a href='javascript: ;'>Close</a></div>";
		$output .= "<div class='open-button'><a href='javascript: ;'>Zoom In</a></div>";

		/* Close the caption </figure>. */
		$output .= '</div>';

		/* Return the formatted, clean figure & figcaption. */
		return $output;
	}

	add_shortcode("photogalleryitem", "MSU_PhotoGalleryItemShortcode");
	$GLOBALS["MLTS_fix_codes"][]= "photogalleryitem";
}



if (!function_exists("MSU_CalendarFeed")) {
	function MSU_CalendarFeed($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("id"=>"", "maxevents"=>"", "startdate"=>"", "enddate"=>"", "metakey"=>"", "metavalue"=>"", "vertical"=>"", "noimages"=>"", "public"=>""), $atts, "calendarfeed");

		$classes = array();
		$classes [] = "prpl-calendar-feed";
		if (isset($a["noimages"]) && $a["noimages"]=="true") {
			$classes []= "no-images";
		}
		if (isset($a["vertical"]) && $a["vertical"]=="true") {
			$classes []= "vertical";
		} else {
			$classes []= "horizontal";
		}

		$retval = '<div class="'.implode(" ", $classes).'" data-calendar-id="'.htmlspecialchars($a["id"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8').'"';
		if (isset($a["maxevents"]) && is_numeric($a["maxevents"])) {
			$a["maxevents"] = intval($a["maxevents"]);
			$retval .= ' data-max-events="'.$a["maxevents"].'"';
		}
		if (!empty($a["startdate"]) && !empty($a["enddate"])) {
			$retval .= ' data-start-date="'.htmlentities($a["startdate"]).'"';
			$retval .= ' data-end-date="'.htmlentities($a["enddate"]).'"';
		} 
		if (!empty($a["metakey"])) {
			$retval .= " data-meta-key=\"".htmlentities($a["metakey"])."\"";
			if (!empty($a["metavalue"])) {
				$retval .= " data-meta-value=\"".htmlentities($a["metavalue"])."\"";
			}
		}
		if (!empty($a["public"])) {
			$retval .= " data-public=\"true\"";
		}
		$regionLabel = "Calendar Event Output";
		if (isset($GLOBALS["MSU_CalendarCount"])) {
			$regionLabel = sprintf("%s %d", $regionLabel, $GLOBALS["MSU_CalendarCount"]);
			$GLOBALS["MSU_CalendarCount"]++;
		} else {
			$GLOBALS["MSU_CalendarCount"] = 1;
		}
		$retval .= sprintf(' role="region" aria-live="off" aria-label="%s"></div>', $regionLabel);
	
		return $retval;
	}

	add_shortcode("calendarfeed", "MSU_CalendarFeed");
	$GLOBALS["MLTS_fix_codes"][]="calendarfeed";
}

if (!function_exists("MSU_CalendarFeed_25Live")) {
	function MSU_CalendarFeed_25Live($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("filter"=>"", "maxevents"=>"", "vertical"=>"", "noimages"=>"", "startdate"=>"", "enddate"=>"", "showtimes"=>"false", "showlocations"=>"false"), $atts, "calendarfeed_25live");

		$classes = array();
		$classes [] = "prpl-calendar-25live";
		if (isset($a["noimages"]) && $a["noimages"]=="true") {
			$classes []= "no-images";
		}
		if (isset($a["vertical"]) && $a["vertical"]=="true") {
			$classes []= "vertical";
		} else {
			$classes []= "horizontal";
		}

		$retval = '<div class="'.implode(" ", $classes).'" data-filter-view="'.htmlspecialchars($a["filter"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8').'"';
		if (isset($a["maxevents"]) && is_numeric($a["maxevents"])) {
			$a["maxevents"] = intval($a["maxevents"]);
			$retval .= ' data-max-events="'.$a["maxevents"].'"';
		}
		if (isset($a["startdate"]) && $a["startdate"]!="" && isset($a["enddate"]) && $a["enddate"]!="") {
			$retval .= sprintf(" data-start-date=\"%s\" data-end-date=\"%s\"", htmlspecialchars($a["startdate"]), htmlspecialchars($a["enddate"]));
		}
		if (isset($a["showtimes"]) && $a["showtimes"]=="true") {
			$retval .= " data-show-times='true'";
		}
		if (isset($a["showlocations"]) && $a["showlocations"]=="true") {
			$retval .= " data-show-location='true'";
		}
		$regionLabel = "Calendar Event Output";
		if (isset($GLOBALS["MSU_CalendarCount"])) {
			$regionLabel = sprintf("%s %d", $regionLabel, $GLOBALS["MSU_CalendarCount"]);
			$GLOBALS["MSU_CalendarCount"]++;
		} else {
			$GLOBALS["MSU_CalendarCount"] = 1;
		}
		$retval .= sprintf(' role="region" aria-live="off" aria-label="%s"></div>', $regionLabel);
	
		return $retval;
	}

	add_shortcode("calendarfeed_25live", "MSU_CalendarFeed_25Live");
	$GLOBALS["MLTS_fix_codes"][]="calendarfeed_25live";
}

if (!function_exists("MSU_Bimonth")) {
	function MSU_Bimonth($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("id"=>"","metakey"=>"", "metavalue"=>""), $atts, "bimonth");

		$classes = array();
		$classes [] = "prpl-calendar-bimonth";

		$retval = '<div class="'.implode(" ", $classes).'" data-calendar-id="'.htmlspecialchars($a["id"], ENT_COMPAT|ENT_HTML5|ENT_QUOTES, 'UTF-8').'"';
		if (!empty($a["metakey"])) {
			$retval .= " data-meta-key=\"".htmlentities($a["metakey"])."\"";
			if (!empty($a["metavalue"])) {
				$retval .= " data-meta-value=\"".htmlentities($a["metavalue"])."\"";
			}
		}
		$regionLabel = "Calendar Event Output";
		if (isset($GLOBALS["MSU_CalendarCount"])) {
			$regionLabel = sprintf("%s %d", $regionLabel, $GLOBALS["MSU_CalendarCount"]);
			$GLOBALS["MSU_CalendarCount"]++;
		} else {
			$GLOBALS["MSU_CalendarCount"] = 1;
		}
		$retval .= sprintf(' role="region" aria-live="off" aria-label="%s"></div>', $regionLabel);
	
		return $retval;
	}

	add_shortcode("bimonth", "MSU_Bimonth");
	$GLOBALS["MLTS_fix_codes"][]="bimonth";
}


if (!function_exists("MSU_NewsFeed")) {
	// call this function on post update
	function MSU_NewsFeed_InvalidateCache() {
		global $wpdb;
		$sql = "SELECT `option_name` AS `name`, `option_value` AS `value`
				FROM  $wpdb->options
				WHERE `option_name` LIKE '_transient_MSUNF%'
				ORDER BY `option_name`";
	
		$results = $wpdb->get_results( $sql );
		$newsFeeds = array();
		foreach ($results as $r) {
			$newsFeeds []= mb_substr($r->name, mb_strlen("_transient_"));
		}

		foreach ($newsFeeds as $nf) {
			delete_transient($nf);
		}
	}

	function MSU_NewsFeed_TransitionPostStatus ($new_status, $old_status, $post) {
		if (("publish" === $new_status || "publish" === $old_status) && ($new_status != $old_status) && $post->post_type=="post") {
			MSU_NewsFeed_InvalidateCache();
		}
	}

	function MSU_NewsFeed_PostUpdated ($post_id, $new_post, $old_post) {
		if ($new_post->post_type == "post") {
			MSU_NewsFeed_InvalidateCache();
		}
	}

	add_action('transition_post_status', 'MSU_NewsFeed_TransitionPostStatus', 10, 3);
	add_action('post_updated', "MSU_NewsFeed_PostUpdated", 10, 3);

	function MSU_NewsFeed($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("site"=>"", "vertical"=>"false", "channel"=>"", "category"=>"", "maxitems"=>"4","noimages"=>"false"), $atts, "newsfeed");

		// scrub attributes
		$a["vertical"] = $a["vertical"]==="true"?true:false;
		if (!is_numeric($a["maxitems"])) $a["maxitems"] = "4";
		$a["maxitems"] = max(3, min(8, intval($a["maxitems"])));

		$transientID = "MSUNF".md5(json_encode($a));
		// delete_transient($transientID);
		$transientText = get_transient($transientID);
		if ($transientText) {
			return json_decode($transientText);
		}

		// check to see if the site name gives us a valid ID
		$FeedBlogID = 0;
		if ($a["site"]) {
			$domain = get_site_url(1);
			$domain = preg_replace("/^http[s]?:\\/\\//i", "", $domain);
			$a["site"] = sprintf("/%s/", preg_replace("/[\\/]/", "", $a["site"]));
			$FeedBlogID = get_blog_id_from_url($domain, $a["site"]);
		}

		// create a place to store output items
		$outputArray = array();

		// switch blogs if needed
		if ($FeedBlogID) switch_to_blog($FeedBlogID);

		// If we don't have a channel number, we assume a pull from WP articles
		if (empty($a["channel"]) || !is_numeric($a["channel"])) {
			// pull three articles
			$args = array(
				'posts_per_page'   => $a["maxitems"],
				'offset'           => 0,
				'category'         => '',
				'category_name'    => $a["category"], // use full name if you want to set this (e.g. "Press Releases")
				'orderby'          => 'date',
				'order'            => 'DESC',
				'include'          => '',
				'exclude'          => '',
				'meta_key'         => '',
				'meta_value'       => '',
				'post_type'        => 'post',
				'post_mime_type'   => '',
				'post_parent'      => '',
				'author'	   => '',
				'author_name'	   => '',
				'post_status'      => 'publish',
				'suppress_filters' => true 
			);
			$posts_array = get_posts( $args );

			foreach($posts_array as $p) {
				$tmp = new stdClass();

				$imgID = get_post_thumbnail_id($p->ID);
				if ($imgID) {
					$tmp->altText = get_post_meta($imgID, '_wp_attachment_image_alt', true);	
					$tmp->inURL = wp_get_attachment_url($imgID);
					$tmp->inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $tmp->inURL);
					
				}

				$tmp->permalink = get_permalink($p);
				$tmp->post_title = $p->post_title;
				if (isset($p->post_excerpt) && !empty($p->post_excerpt)) {
					$tmp->post_excerpt = $p->post_excerpt;
				}
				$tmp->post_date = strtotime($p->post_date_gmt." GMT");

				$outputArray[] = $tmp;
			}
			
		} else {
			$params = array();
			$params["id"] = intval($a["channel"]);
			$params["MaxItems"] = $a["maxitems"];

			$qs = array();
			foreach ($params as $key=>$val) {
				$qs []= $key."=".urlencode($val);
			}
			$qs = implode("&", $qs);

			// echo $qs;

			$data = file_get_contents("https://www.montclair.edu/news/data/channel.php?".$qs);
			$data = json_decode($data, true);
			if ($data["status"] && $data["status"]=="success") {
				foreach ($data["data"] as $p) {
					$tmp = new stdClass();

					if ($p["featurePhoto"]) {
						$tmp->inURL = "/news/images/feature/originals/".$p["featurePhoto"];
						$tmp->altText = "";
					}
					
					$tmp->permalink = "http://www.montclair.edu/news/article.php?ArticleID=".$p["id"];
					$tmp->post_title = $p["headline"];
					if ($p["lead"]) {
						$tmp->post_excerpt = $p["lead"];
					}
					$tmp->post_date = strtotime($p["creationDate"]);

					$outputArray[] = $tmp;
				}
			}

			// this should've been taken care of by the querystring but it doesn't seem to be?
			$outputArray = array_slice($outputArray, 0, $a["maxitems"]);
		}
		
		
		$retval = "";
		foreach ($outputArray as $p) {
			$retval .= "<li class='news-item'>";

			$retval .= "<div class='image-holder'>";
			if (isset($p->inURL) && !empty($p->inURL)) {
				$retval .= ("<img class=\"mlt-responsive-background\" ");
				$retval .= (" data-original-image=\"".$p->inURL."\"");
				$retval .= (" src=\"/responsive-media/cache".$p->inURL.".0.1x.generic.jpg\"");
				$retval .= (" alt=\"".htmlspecialchars($p->altText, ENT_HTML5|ENT_COMPAT|ENT_QUOTES, "UTF-8")."\"");
				$retval .= (" />");
				
			}
			$retval .= "</div>";
			$retval .= "<span class='headline'><a href=\"".$p->permalink."\">".($p->post_title)."</a></span>";
			if (isset($p->post_excerpt) && !empty($p->post_excerpt)) {
				$retval .= "<span class='sub-head'>".$p->post_excerpt."</span>";
			}
			$retval .= "<span class='posted'>".date("l F j, Y", $p->post_date)."</span>";

			$retval .= "</li>";
			
		}
		
		$retval = "<ul class='news-feed".($a["vertical"]?" vertical":" horizontal").($a["noimages"]=="true"?" no-images":"")."'>".$retval."</ul>";

		// if we've switched blogs, return to the original blog
		if ($FeedBlogID) restore_current_blog();
		// only store a transient if we're pulling from the same blog since
		// there's no way for the other blog to know to invalidate the
		// transient when an article gets published.
		else set_transient($transientID, json_encode($retval), 60*60);

		return $retval;
		
	}

	add_shortcode("newsfeed", "MSU_NewsFeed");

	function MSU_HomepageNewsBand($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("site"=>"", "channel"=>"", "category"=>"", "maxitems"=>"4", "morelabel"=>"", "moreurl"=>"", "campaign"=>""), $atts, "homepagenewsband");

		// scrub attributes
		$a["maxitems"] = "4"; // we always want a max of 4 for this

		$transientID = "MSUHNB".md5(json_encode($a));
		// while testing, keep deleting the transient
		delete_transient($transientID);
		$transientText = get_transient($transientID);
		if ($transientText) {
			return json_decode($transientText);
		}

		// check to see if the site name gives us a valid ID
		$FeedBlogID = 0;
		if ($a["site"]) {
			$domain = get_site_url(1);
			$domain = preg_replace("/^http[s]?:\\/\\//i", "", $domain);
			$a["site"] = sprintf("/%s/", preg_replace("/[\\/]/", "", $a["site"]));
			$FeedBlogID = get_blog_id_from_url($domain, $a["site"]);
		}

		// create a place to store output items
		$outputArray = array();

		// switch blogs if needed
		if ($FeedBlogID) switch_to_blog($FeedBlogID);

		// pull articles
		$args = array(
			'posts_per_page'   => $a["maxitems"],
			'offset'           => 0,
			'category'         => '',
			'category_name'    => $a["category"], // use full name if you want to set this (e.g. "Press Releases")
			'orderby'          => 'date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'post',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	   => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$posts_array = get_posts( $args );

		foreach($posts_array as $p) {
			$tmp = new stdClass();

			$imgID = get_post_thumbnail_id($p->ID);
			if ($imgID) {
				$tmp->altText = get_post_meta($imgID, '_wp_attachment_image_alt', true);	
				$tmp->inURL = wp_get_attachment_url($imgID);
				$tmp->inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $tmp->inURL);
				
			}

			$tmp->permalink = get_permalink($p);
			// if there's a campaign parameter
			if (isset($a["campaign"]) && !empty($a["campaign"])) {
				// if there's an existing query string
				if (mb_strpos($tmp->permalink, "?") !== false) {
					$tmp->permalink = sprintf("%s&utm_source=news_feed&utm_medium=web&utm_campaign=%s", $tmp->permalink, urlencode($a["campaign"]));
				// if there's NOT an existing query string
				} else {
					$tmp->permalink = sprintf("%s?utm_source=news_feed&utm_medium=web&utm_campaign=%s", $tmp->permalink, urlencode($a["campaign"]));
				}
			}
			$tmp->post_title = $p->post_title;
			if (isset($p->post_excerpt) && !empty($p->post_excerpt)) {
				$tmp->post_excerpt = $p->post_excerpt;
			}
			$tmp->post_date = strtotime($p->post_date_gmt." GMT");

			$outputArray[] = $tmp;
		}
		
		
		if (count($outputArray) < 2) return "";		// no idea what to do if there are fewer than 2 items
		
		// first put together the HTML for the left column
		$p = $outputArray[0];
		$leftColumnHTML = "";
		$leftColumnHTML .= "<li class='news-item'>";
		$leftColumnHTML .= "<figure class='responsive-image-holder'>";
		if (isset($p->inURL)) {
			$leftColumnHTML .= ("<img class=\"mlt-responsive-background wide\" ");
			$leftColumnHTML .= (" data-original-image=\"".$p->inURL."\"");
			$leftColumnHTML .= (" src=\"/responsive-media/cache".$p->inURL.".0.1x.wide.jpg\"");
			$leftColumnHTML .= (" alt=\"".htmlspecialchars($p->altText, ENT_HTML5|ENT_COMPAT|ENT_QUOTES, "UTF-8")."\"");
			$leftColumnHTML .= (" />");
		}
		$leftColumnHTML .= "</figure>";
		$leftColumnHTML .= "<span class='headline'><a href=\"".$p->permalink."\">".($p->post_title)."</a></span>";
		if (isset($p->post_excerpt) && !empty($p->post_excerpt)) {
			$leftColumnHTML .= "<span class='sub-head'>".$p->post_excerpt."</span>";
		}
		$leftColumnHTML .= "<span class='posted'>".date("l F j, Y", $p->post_date)."</span>";
		$leftColumnHTML .= "</li>";
		$leftColumnHTML = sprintf("<ul class='news-feed vertical no-images'>%s</ul>", $leftColumnHTML);

		// now the same in the right column
		$outputArray = array_slice($outputArray, 1);
		$rightColumnHTML = "";
		foreach ($outputArray as $p) {
			$rightColumnHTML .= "<li class='news-item'>";
			$rightColumnHTML .= "<span class='headline'><a href=\"".$p->permalink."\">".($p->post_title)."</a></span>";
			if (isset($p->post_excerpt) && !empty($p->post_excerpt)) {
				$rightColumnHTML .= "<span class='sub-head'>".$p->post_excerpt."</span>";
			}
			$rightColumnHTML .= "<span class='posted'>".date("l F j, Y", $p->post_date)."</span>";
			$rightColumnHTML .= "</li>";
		}
		if (!empty($a["morelabel"]) && !empty($a["moreurl"])) {
			$rightColumnHTML .= sprintf("<p class='more-info-link'><span class='prpl-button'><a href='%s'>%s</a></span></p>",
				$a["moreurl"], $a["morelabel"]);
		}
		$rightColumnHTML = sprintf("<ul class='news-feed vertical no-images'>%s</ul>", $rightColumnHTML);


		// put the two columns into one row
		$retval = sprintf("<div class=\"prpl-row\">
			<div class=\"prpl-column two-thirds\">%s</div>
			<div class=\"prpl-column one-third\">%s</div>
		</div>", $leftColumnHTML, $rightColumnHTML);

		// if we've switched blogs, return to the original blog
		if ($FeedBlogID) restore_current_blog();
		// only store a transient if we're pulling from the same blog since
		// there's no way for the other blog to know to invalidate the
		// transient when an article gets published.
		else set_transient($transientID, json_encode($retval), 60*60);

		return $retval;
		
	}

	add_shortcode("homepagenewsband", "MSU_HomepageNewsBand");
}

if (!function_exists("MSU_ProfileDisplay")) {
	function MSU_ProfileDisplay($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("netid"=>"", "smallphoto"=>"false", "hidden"=>"", "showprofile"=>"false", "showspecialization"=>"false"), $atts, "profile");
		$t1 = microtime(true);

		$retval = "";

		$netIDs = preg_replace("/[^a-zA-Z0-9,]/", "", $a["netid"]);
		$transientID = "p_".md5($netIDs);

		$tmp = false;
		$debugMessages = "";

		if (false && $_SERVER["HTTP_HOST"]=="www.montclair.edu") {
			ob_start();
			passthru(sprintf("php-cgi /opt/htdocs/www/includes/user_directory/data.php type=profile NetID=%s", escapeshellarg($netIDs)));
			$tmp = ob_get_contents();
			ob_end_clean();
		}

		if ($tmp) {
			$tmp = mb_substr($tmp, mb_stripos($tmp, "{"));
			$t2 = microtime(true);
			$debugMessages .= sprintf("\n<!-- fetch direct: %5.2f ms -->", 1000*($t2-$t1));
			$t1 = $t2;
		} else {
			$tmp = get_transient($transientID);
			if ($tmp) {
				$t2 = microtime(true);
				$debugMessages .= sprintf("\n<!-- fetch cache: %5.2f ms -->", 1000*($t2-$t1));
				$t1 = $t2;
			} else {
				$tmp = file_get_contents("https://www.montclair.edu/includes/user_directory/data.php?type=profile&NetID=".urlencode($netIDs));
				// set_transient($transientID, $tmp, 86400+rand(0,7200)-3600); // one day +/- 1 hour so that maybe we don't pull ALL of them at once
				set_transient($transientID, $tmp, 15*60); // 15 minute transient becuase the file_get_contents penalty has been cleared up
				$t2 = microtime(true);
				$debugMessages .= sprintf("\n<!-- fetch new: %5.2f ms -->", 1000*($t2-$t1));
				$t1 = $t2;
			}
		}
		
		$tmp = json_decode($tmp, true);
		$t2 = microtime(true);
		$debugMessages .= sprintf("\n<!-- decode: %5.2f ms -->", 1000*($t2-$t1));
		$t1 = $t2;

		$hidden = array();
		if (!empty($a["hidden"])) {
			$hidden = explode(",", $a["hidden"]);
			for ($i=0;$i<count($hidden);$i++) {
				$hidden[$i] = trim($hidden[$i]);
			}
		}

		if ($tmp && $tmp["status"]=="success") {
			foreach($tmp["data"] as $p) {
				$tmpHTML = "";
				// disable middleName entirely
				if (array_search("middlename", $hidden)===false && false){
					$personName = str_replace("  ", " ", $p["givenName"]." ".$p["middleName"]." ".$p["surname"]);
				} else {
					$personName = str_replace("  ", " ", $p["givenName"]." ".$p["surname"]);
				}
				$p["netid"] = explode("@", $p["mail"]);
				$p["netid"] = $p["netid"][0];
				if (array_search("photo", $hidden)===false && $p["coverpage"]["photo"]) {
					$p["coverpage"]["file_location"] = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $p["coverpage"]["file_location"]);
					$tmpHTML .= "<div class=\"profile-picture\">";
					$tmpHTML .= "<img class=\"mlt-responsive-image\" alt=\"".htmlentities($personName)." profile photo\" ";
					$tmpHTML .= "data-original-image=\"".$p["coverpage"]["file_location"].$p["coverpage"]["photo"]."\" ";
					$tmpHTML .= "src=\"/responsive-media/cache".$p["coverpage"]["file_location"].$p["coverpage"]["photo"].".0.1x.generic.jpg\" />";
					$tmpHTML .= "</div>";
				} else {
					$tmpHTML .= "<div class=\"no-photo\"></div>";
				}

				$tmpHTML .= "<div class=\"profile-data\">";

				// name
				$tmpHTML .= "<p class=\"name\"><a href=\"http://www.montclair.edu/~".$p["netid"]."\">";
				$tmpHTML .= htmlspecialchars($personName);
				$tmpHTML .= "</a></p>";

				// title
				if (array_search("title", $hidden)===false) {
					if (array_search("department", $hidden)===false) {
						$p["title"] = str_replace(", ".$p["department"]["name"], "", $p["title"]);
						$tmpHTML .= "<p class=\"title\">".htmlspecialchars(sprintf("%s, %s", $p["title"], $p["department"]["name"]))."</p>";
					} else {
						$tmpHTML .= "<p class=\"title\">".htmlspecialchars(sprintf("%s", $p["title"]))."</p>";
					}
				}

				$tmpHTML .= "<dl class=\"compact\">";

				// phone
				if (array_search("phone", $hidden)===false) {
					$p["phone"] = preg_replace("/[^0-9]/", "", $p["phone"]);
					if (mb_strlen($p["phone"])==10) {
						$p["phone"] = sprintf("%s-%s-%s", substr($p["phone"], 0, 3), substr($p["phone"], 3, 3), substr($p["phone"], 6, 4));
						$tmpHTML .= "<dt>Phone</dt>";
						$tmpHTML .= "<dd><a class=\"a11y-phone-number\" href=\"tel:".$p["phone"]."\">".$p["phone"]."</a></dd>";	
					}
				}


				// email
				if (array_search("email", $hidden)===false) {
					$tmpHTML .= "<dt>Email</dt>";
					$tmpHTML .= "<dd><a href=\"mailto:".htmlspecialchars($p["mail"])."\">".htmlspecialchars($p["mail"])."</a></dd>";
				}
				// location
				if (array_search("location", $hidden)===false && isset($p["location"]) && $p["location"]["building"]) {
					$tmpHTML .= "<dt>Location</dt>";
					$tmpHTML .= "<dd>".$p["location"]["building"].($p["location"]["room"]?", ".$p["location"]["room"]:"")."</dd>";
				}

				$tmpHTML .= "</dl>";

				$needsLabel = ($a["showprofile"]=="true" && $a["showspecialization"]=="true");

				if ($a["showprofile"]=="true" && isset($p["coverpage"]["profile_html"]) && !empty($p["coverpage"]["profile_html"])) {
					$tmpHTML .= sprintf("<div class=\"bio\">%s%s</div>\n", ($needsLabel?"<p><strong>Profile</strong></p>":""), $p["coverpage"]["profile_html"]);
				}

				if ($a["showspecialization"]=="true" && isset($p["coverpage"]["specialization_html"]) && !empty($p["coverpage"]["specialization_html"])) {
					$tmpHTML .= sprintf("<div class=\"specialization\">%s%s</div>\n", ($needsLabel?"<p><strong>Specialization</strong></p>":""), $p["coverpage"]["specialization_html"]);
				}

				$tmpHTML .= "</div>";

				$class = array();
				$class[] = "profile";
				if ($a["smallphoto"]=="true") {
					$class[] = "smallphoto";
				}

				$tmpHTML = "<div class=\"".implode(" ", $class)."\">".$tmpHTML."</div>";
				$retval .= $tmpHTML;
			}
		} else {
			$retval = "<p><em>Error: </em>Unable to retrieve profile information.</p>";
		}

		$t2 = microtime(true);
		$debugMessages .= sprintf("\n<!-- output: %5.2f ms -->", 1000*($t2-$t1));
		$t1 = $t2;

		$retval = sprintf("<p class='a11y-label'>%s</p>%s", $debugMessages, $retval);
		return $retval;
	}

	add_shortcode("profile", "MSU_ProfileDisplay");
	$GLOBALS["MLTS_fix_codes"][]="profile";
}

if (!function_exists("MSU_ProfileTableDisplay")) {
	function MSU_ProfileTableDisplay($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("netid"=>"", "smallphoto"=>"false", "hidden"=>""), $atts, "profiletable");
		$t1 = microtime(true);
		
		$retval = "";
		$debugMessages = "";

		$netIDs = preg_replace("/[^a-zA-Z,0-9]/", "", $a["netid"]);
		$transientID = "pt_".md5($netIDs);

		$tmp = false;

		if (false && $_SERVER["HTTP_HOST"]=="www.montclair.edu") {
			ob_start();
			passthru(sprintf("php-cgi /opt/htdocs/www/includes/user_directory/data.php type=profile NetID=%s", escapeshellarg($netIDs)));
			$tmp = ob_get_contents();
			ob_end_clean();
		}

		if ($tmp) {
			$tmp = mb_substr($tmp, mb_stripos($tmp, "{"));
			$t2 = microtime(true);
			$debugMessages .= sprintf("\n<!-- fetch direct: %5.2f ms -->", 1000*($t2-$t1));
			$t1 = $t2;
		} else {
			$tmp = get_transient($transientID);
			if ($tmp) {
				$t2 = microtime(true);
				$debugMessages .= sprintf("\n<!-- fetch cache: %5.2f ms -->", 1000*($t2-$t1));
				$t1 = $t2;
			} else {
				$tmp = file_get_contents("https://www.montclair.edu/includes/user_directory/data.php?type=profile&NetID=".urlencode($netIDs));
				// set_transient($transientID, $tmp, 86400+rand(0,7200)-3600); // one day +/- 1 hour so that maybe we don't pull ALL of them at once
				set_transient($transientID, $tmp, 15*60); // cache for 15 minutes
				$t2 = microtime(true);
				$debugMessages .= sprintf("\n<!-- fetch new: %5.2f ms -->", 1000*($t2-$t1));
				$t1 = $t2;
			}
		}

		$tmp = json_decode($tmp, true);
		$t2 = microtime(true);
		$debugMessages .= sprintf("\n<!-- decode: %5.2f ms -->", 1000*($t2-$t1));
		$t1 = $t2;

		$hidden = array();
		if (!empty($a["hidden"])) {
			$hidden = explode(",", $a["hidden"]);
			for ($i=0;$i<count($hidden);$i++) {
				$hidden[$i] = trim($hidden[$i]);
			}
		}

		if ($tmp && $tmp["status"]=="success") {
			// start by creating the table
			$retval .= "<table class=\"responsive-table\">";
			// create the header row
			$retval .= "<thead><tr>";
			$retval .= "<th>Name</th>";
			if (array_search("title", $hidden)===false) $retval .= "<th>Title</th>";
			if (array_search("location", $hidden)===false) $retval .= "<th>Location</th>";
			if (array_search("phone", $hidden)===false) $retval .= "<th>Phone</th>";
			if (array_search("email", $hidden)===false) $retval .= "<th>Email</th>";
			$retval .= "</tr></thead>";
			// create the tbody
			$retval .= "<tbody>";
			foreach($tmp["data"] as $p) {
				// prep data
				if (array_search("middlename", $hidden)===false){
					$personName = str_replace("  ", " ", $p["givenName"]." ".$p["middleName"]." ".$p["surname"]);
				} else {
					$personName = str_replace("  ", " ", $p["givenName"]." ".$p["surname"]);
				}
				$p["netid"] = explode("@", $p["mail"]);
				$p["netid"] = $p["netid"][0];

				// begin the row
				$retval .= "<tr>";

				// name
				$retval .= "<td style='white-space: nowrap;'><a href=\"http://www.montclair.edu/~".$p["netid"]."\">";
				$retval .= htmlspecialchars($personName);
				$retval .= "</a></td>";

				// title
				if (array_search("title", $hidden)===false) {
					if (array_search("department", $hidden)===false) {
						$retval .= "<td>".htmlspecialchars(sprintf("%s, %s", $p["title"], $p["department"]["name"]))."</td>";
					} else {
						$retval .= "<td>".htmlspecialchars(sprintf("%s", $p["title"]))."</td>";
					}
					
				}

				// location
				if (array_search("location", $hidden)===false && isset($p["location"]) && $p["location"]["building"]) {
					$retval .= "<td>".$p["location"]["building"].($p["location"]["room"]?", ".$p["location"]["room"]:"")."</td>";
				} else if (array_search("location", $hidden)===false) {
					$retval .= "<td>&nbsp;</td>";
				}

				// phone
				if (array_search("phone", $hidden)===false) {
					$p["phone"] = preg_replace("/[^0-9]/i","", $p["phone"]);
					if (strlen($p["phone"])!=10) {
						$p["phone"] = null;
						$retval .= "<td></td>";
					} else {
						$p["phone"] = sprintf("%s-%s-%s", substr($p["phone"], 0, 3), substr($p["phone"], 3, 3), substr($p["phone"], 6, 4));
						$retval .= "<td><a class=\"a11y-phone-number\" href=\"tel:".$p["phone"]."\">".$p["phone"]."</a></td>";
					}
				}

				// email
				if (array_search("email", $hidden)===false) {
					$retval .= "<td><a href=\"mailto:".htmlspecialchars($p["mail"])."\">".htmlspecialchars($p["mail"])."</a></td>";
				}

				// end the row
				$retval .= "</tr>";
			}
			// end the tbody & table
			$retval .= "</tbody></table>";
		} else {
			$retval = "<p><em>Error: </em>Unable to retrieve profile information.</p>";
		}
		$t2 = microtime(true);
		$debugMessages .= sprintf("\n<!-- format output: %5.2f ms -->", 1000*($t2-$t1));
		$t1 = $t2;

		$retval = sprintf("<p class='a11y-label'>%s</p>%s", $debugMessages, $retval);
		return $retval;
	}

	add_shortcode("profiletable", "MSU_ProfileTableDisplay");
	$GLOBALS["MLTS_fix_codes"][]="profiletable";
}

if (!function_exists("MSU_ProfileGridDisplay")) {
	function MSU_ProfileGridDisplay($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("netid"=>"", "email"=>"true", "phone"=>"true", "single"=>"false"), $atts, "profilegrid");
		$t1 = microtime(true);

		$retval = "";
		$debugMessages = "";

		$netIDs = preg_replace("/[^a-zA-Z0-9,]/", "", $a["netid"]);
		$transientID = "p_".md5($netIDs);

		$tmp = false;

		if (false && $_SERVER["HTTP_HOST"]=="www.montclair.edu") {
			ob_start();
			passthru(sprintf("php-cgi /opt/htdocs/www/includes/user_directory/data.php type=profile NetID=%s", escapeshellarg($netIDs)));
			$tmp = ob_get_contents();
			ob_end_clean();
		}

		if ($tmp) {
			$tmp = mb_substr($tmp, mb_stripos($tmp, "{"));
			$t2 = microtime(true);
			$debugMessages .= sprintf("\n<!-- fetch direct: %5.2f ms -->", 1000*($t2-$t1));
			$t1 = $t2;
		} else {
			$tmp = get_transient($transientID);
			if ($tmp) {
				$t2 = microtime(true);
				$debugMessages .= sprintf("<!-- fetch cache: %5.2f ms -->", 1000*($t2-$t1));
				$t1 = $t2;
			} else {
				$tmp = file_get_contents("https://www.montclair.edu/includes/user_directory/data.php?type=profile&NetID=".urlencode($netIDs));
				// set_transient($transientID, $tmp, 86400+rand(0,7200)-3600); // one day +/- 1 hour so that maybe we don't pull ALL of them at once
				set_transient($transientID, $tmp, 15*60); // cache for 15 minutes
				$t2 = microtime(true);
				$debugMessages .= sprintf("<!-- fetch new: %5.2f ms -->", 1000*($t2-$t1));
				$t1 = $t2;
			}
		}
		
		$tmp = json_decode($tmp, true);
		$t2 = microtime(true);
		$debugMessages .= sprintf("<!-- decode: %5.2f ms -->", 1000*($t2-$t1));
		$t1 = $t2;

		$hidden = array();

		if ($tmp && $tmp["status"]=="success") {
			$listHTML = "";
			foreach($tmp["data"] as $p) {
				$tmpHTML = "";
				// disable middleName entirely
				if (array_search("middlename", $hidden)===false && false){
					$personName = str_replace("  ", " ", $p["givenName"]." ".$p["middleName"]." ".$p["surname"]);
				} else {
					$personName = str_replace("  ", " ", $p["givenName"]." ".$p["surname"]);
				}
				$p["netid"] = explode("@", $p["mail"]);
				$p["netid"] = $p["netid"][0];
				if (array_search("photo", $hidden)===false && $p["coverpage"]["photo"]) {
					$p["coverpage"]["file_location"] = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $p["coverpage"]["file_location"]);
					$tmpHTML .= "<div class=\"profile-photo\">";
					$tmpHTML .= "<img class=\"mlt-responsive-background\" alt=\"".htmlentities($personName)." profile photo\" ";
					$tmpHTML .= "data-original-image=\"".$p["coverpage"]["file_location"].$p["coverpage"]["photo"]."\" ";
					$tmpHTML .= "src=\"/responsive-media/cache".$p["coverpage"]["file_location"].$p["coverpage"]["photo"].".0.1x.generic.jpg\" />";
					$tmpHTML .= "</div>";
				} else {
					$tmpHTML .= "<div class=\"no-photo\"></div>";
				}

				$tmpHTML .= "<div class=\"profile-text\">";

				// name
				$tmpHTML .= "<span class=\"name\"><a href=\"http://www.montclair.edu/~".$p["netid"]."\">";
				$tmpHTML .= htmlspecialchars($personName);
				$tmpHTML .= "</a></span>";

				// title
				$tmpHTML .= "<span class=\"title\">".htmlspecialchars(sprintf("%s", $p["title"]))."</span>";


				// phone
				if (isset($a["phone"]) && $a["phone"]=="true") {
					$p["phone"] = preg_replace("/[^0-9]/", "", $p["phone"]);
					if (mb_strlen($p["phone"])==10) {
						$p["phone"] = sprintf("%s-%s-%s", substr($p["phone"], 0, 3), substr($p["phone"], 3, 3), substr($p["phone"], 6, 4));
						$tmpHTML .= "<span class=\"phone\"><a class=\"a11y-phone-number\" href=\"tel:".$p["phone"]."\">".$p["phone"]."</a></span>";	
					}
				}

				// email
				if (isset($a["email"]) && $a["email"]=="true") {
					$tmpHTML .= "<span class=\"email\"><a href=\"mailto:".htmlspecialchars($p["mail"])."\">".htmlspecialchars($p["mail"])."</a></span>";
				}

				$tmpHTML .= "</div>"; // end div.profile-text

				// wrap it all up
				$tmpHTML = "<li><div class=\"card\">".$tmpHTML."</div></li>";

				$listHTML .= $tmpHTML;
			}
			// end of the loop, let's put all these list items in a UL
			$retval .= "<ul class=\"profile-grid".(isset($a["single"])&&$a["single"]=="true"?" single":"")."\">".$listHTML."</ul>";
		} else {
			$retval = "<p><em>Error: </em>Unable to retrieve profile information.</p>";
		}

		$t2 = microtime(true);
		$debugMessages .= sprintf("<!-- output: %5.2f ms -->", 1000*($t2-$t1));
		$t1 = $t2;
		
		$retval = sprintf("<p class='a11y-label'>%s</p>%s", $debugMessages, $retval);
		return $retval;
	}

	add_shortcode("profilegrid", "MSU_ProfileGridDisplay");
	$GLOBALS["MLTS_fix_codes"][]="profilegrid";
}


if (!function_exists("MSU_IconBar")) {
	function MSU_IconBar($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "iconbar");
		
		// build the tag's class name as default + $a["class"]
		$class = "prpl-icon-bar";
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		$retval = "<div class=\"".$class."\">".$content."</div>";
		
		
		return $retval;
	}

	add_shortcode("iconbar", "MSU_IconBar");
	$GLOBALS["MLTS_fix_codes"][]="iconbar";
}

if (!function_exists("MSU_PhotoButton")) {
	function MSU_PhotoButton($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"vertical"), $atts, "photobutton");

		// build the tag's class name as default + $a["class"]
		$class = "photo-button ".$a["class"];
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);

		// Let's do this the quick and dirty way - grab the IMG SRC and A HREF
		$src_matches = array();
		if (!preg_match("/src=[\\\"\\']([^\\\"\\']+)/i", $content, $src_matches)) return "missing src";
		$href_matches = array();
		if (!preg_match("/href=[\\\"\\']([^\\\"\\']+)/i", $content, $href_matches)) return "missing href";

		$isBackground = false;
		if (stripos($a["class"], "version-2") !== false) $isBackground = true;

		$retval = "";
		$retval .= "<span class='image-holder'>";
		$retval .= getResponsiveImageTag($src_matches[1], $isBackground, true);
		$retval .= "</span>";
		$retval .= "<span class='text-content'>";
		$retval .= str_replace("\n", "", strip_tags($content, "<strong>"));
		$retval .= "</span>";

		$retval = sprintf("<a href=\"%s\" class=\"%s\">%s</a>", $href_matches[1], $class, $retval);

		return $retval;
	}

	add_shortcode("photobutton", "MSU_PhotoButton");
	$GLOBALS["MLTS_fix_codes"][]="photobutton";
}


if (!function_exists("MSU_Inset")) {
	function MSU_Inset($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"lt-gray"), $atts, "inset");
		
		// build the tag's class name as default + $a["class"]
		$class = "inset".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		$retval = sprintf("<div class='%s'>%s</div>", $class, $content);

		return $retval;
	}

	add_shortcode("inset", "MSU_Inset");
	$GLOBALS["MLTS_fix_codes"][]="inset";
}





if (!function_exists("MSU_GPACalc")) {
	function MSU_GPACalc($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "gpacalc");
		
		wp_enqueue_script("enyo");
		wp_enqueue_script("gpa-calc");
		wp_enqueue_style("gpa-calc");

		$retval = "<div id='GPACalculator'></div>";
		
		return $retval;
	}

	add_shortcode("gpacalc", "MSU_GPACalc");
	$GLOBALS["MLTS_fix_codes"][]="gpacalc";
}


if (!function_exists("MSU_BeforeAndAfter")) {
	function MSU_BeforeAndAfter($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>""), $atts, "beforeandafter");
		
		// build the tag's class name as default + $a["class"]
		$class = "before-and-after".(empty($a["class"])?"":" ".$a["class"]);
		
		// get content
		$matches = array();
		$tmp = preg_match_all("/src=\"([^\"]+)\"/i", $content, $matches);
		
		$retval = "";
		if ($tmp == 2) {
			foreach($matches[1] as $inURL) {
				$imgID = mpGetIDFromURL($inURL);
				if (!$imgID) {
					$altText = "";
				} else {
					$altText = get_post_meta($imgID, '_wp_attachment_image_alt', true);	
				}
			
				$discoveredURL = wp_get_attachment_image_src($imgID, "full");
				if ($discoveredURL) {
					$inURL = $discoveredURL[0];
				}
				$inURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $inURL);
				$retval .= sprintf("<img src=\"%s\" alt=\"%s\" />",
					$inURL, htmlspecialchars($altText));
			}
			$retval = sprintf("<div class=\"%s\">%s</div>", $class, $retval);
		}
		
		return $retval;
	}

	add_shortcode("beforeandafter", "MSU_BeforeAndAfter");
	$GLOBALS["MLTS_fix_codes"][]="beforeandafter";
}


if (!function_exists("MSU_Hotspot")) {
	function MSU_Hotspot($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("image"=>""), $atts, "hotspot");
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		// build HTML
		$retval = $content;
		if (!empty($a["image"])) {
			$imgtag = getResponsiveImageTag($a["image"], false);
			$retval = $imgtag.$retval;
		}
		$retval = "<div class=\"hotspot\">".$retval."</div>";
		
		
		return $retval;
	}

	add_shortcode("hotspot", "MSU_Hotspot");
	$GLOBALS["MLTS_fix_codes"][]="hotspot";
}

if (!function_exists("MSU_HotspotPoint")) {
	function MSU_HotspotPoint($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("left"=>"", "top"=>"", "label"=>"label", "url"=>""), $atts, "hotpoint");

		if (!is_numeric($a["left"])) return "";
		if (!is_numeric($a["top"])) return "";
		if (!isset($a["label"]) || empty($a["label"])) return "";

		$a["left"] = sprintf("%0.2f%%", floatval($a["left"]));
		$a["top"] = sprintf("%0.2f%%", floatval($a["top"]));
		$a["label"] = htmlspecialchars($a["label"]);

		if (isset($a["url"]) && !empty($a["url"])) {
			$a["url"] = htmlspecialchars($a["url"]);
			$retval = sprintf("<a href='%s' class='hotspot-point' tabindex='0' style='left:%s; top:%s;'><span class='text'>%s</span></a>", $a["url"], $a["left"], $a["top"], $a["label"]);
		} else {
			$retval = sprintf("<span class='hotspot-point' tabindex='0' style='left:%s; top:%s;'><span class='text'>%s</span></span>", $a["left"], $a["top"], $a["label"]);
		}
		
		return $retval;
	}

	add_shortcode("hotpoint", "MSU_HotspotPoint");
	$GLOBALS["MLTS_fix_codes"][]="hotpoint";
}

if (!function_exists("MSU_GoogleCalendarIFRAME")) {
	function MSU_GoogleCalendarIFRAME($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("url"=>""), $atts, "googlecalendar");

		// ensure URL is set
		if (empty($a["url"])) return "";

		// parse URL to get querystring
		$url = parse_url($a["url"]);
		if (!isset($url["query"])) return "";

		// parse querystring to get associative array
		parse_str($url["query"], $url); // doesn't return a value - so input is $url and output is $url 

		// ensure the querystring has a SRC attribute
		if (!isset($url["src"])) return "";

		// build a new querystring with just the src and timezone attributes
		$qs = array();
		$qs["src"] = $url["src"];
		$qs["ctz"] = "America/New_York";

		// create a new (hopefully sanitized) URL
		$url = "https://calendar.google.com/calendar/embed?".http_build_query($qs);

		$transientKey = "gcal_".md5($url);

		$title = get_transient($transientKey);

		if (!$title) {
			// try to get the url
			$tmp = file_get_contents($url);
			if (!$tmp) return false;

			// if we got the doc try to get the title
			$start = mb_stripos($tmp, "<title>");
			if ($start === false) return false;
			$start += mb_strlen("<title>");
			$end = mb_stripos($tmp, "</title>", $start);
			if ($end === false) return false;
			$title = mb_substr($tmp, $start, $end-$start);
			if ($title == "Google Calendar") {
				return sprintf("<p><em>This calendar is not public.</em> <a href=\"%s\" target=\"_blank\" rel=\"noreferer\">View Calendar <span class='a11y-label'>%s<span></a></p>", $url, $url);
			}
			set_transient($transientKey, $title);
		}

		// return embed code
		$retval = sprintf("<iframe src=\"%s\" title=\"%s\" style=\"border: 0; width: 100%%; height: 600px; overflow: hidden;\"></iframe>", $url, $title);
		
		
		return $retval;
	}

	add_shortcode("googlecalendar", "MSU_GoogleCalendarIFRAME");
	$GLOBALS["MLTS_fix_codes"][]="googlecalendar";
}

if (!function_exists("MSU_NJVid")) {
	function MSU_NJVid($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("url"=>"", "title"=>""), $atts, "njvid");

		$a["title"] = trim($a["title"]);
		if (empty($a["title"])) return "<p>Error: Title required for NJVid shortcode.</p>";

		if (stripos($a["url"], "&amp;")) {
			$a["url"] = html_entity_decode($a["url"]);
		}
		$url = parse_url($a["url"]);
		if (!$url) return "<p>Error: Invalid URL supplied for NJVid shortcode.</p>";
		
		$a["url"] = htmlspecialchars($a["url"]);
		$a["title"] = htmlspecialchars($a["title"]);
		$retval = sprintf("<iframe src=\"%s\" allowfullscreen=\"true\" title=\"%s\" style=\"border: none;\"></iframe>", $a["url"], $a["title"]);
		
		return $retval;
	}

	add_shortcode("njvid", "MSU_NJVid");
	$GLOBALS["MLTS_fix_codes"][]="njvid";
}

if (!function_exists("MSU_Panopto")) {
	function MSU_Panopto($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("url"=>"", "title"=>""), $atts, "panopto");

		$a["title"] = trim($a["title"]);
		if (empty($a["title"])) return "<p>Error: Title required for Panopto shortcode.</p>";

		if (stripos($a["url"], "&amp;")) {
			$a["url"] = html_entity_decode($a["url"]);
		}
		$url = parse_url($a["url"]);
		if (!$url) return "<p>Error: Invalid URL supplied for Panopto shortcode.</p>";

		if (!isset($url["query"]) || empty($url["query"])) return "<p>Error: Unable to get Video ID</p>";
		$result = array();
		parse_str($url["query"], $result);

		if (!isset($result["id"]) || empty($result["id"])) return "<p>Error: Unable to get Video ID</p>";
		
		$result["id"] = urlencode($result["id"]);
		$a["title"] = htmlspecialchars($a["title"]);
		$retval = sprintf("<iframe src=\"https://montclair.hosted.panopto.com/Panopto/Pages/Embed.aspx?v=1&amp;id=%s\" allowfullscreen=\"true\" title=\"%s\" style=\"border: none;\"></iframe>", $result["id"], $a["title"]);
		
		return $retval;
	}

	add_shortcode("panopto", "MSU_Panopto");
	$GLOBALS["MLTS_fix_codes"][]="panopto";
}

if (!function_exists("MSU_SensusAccess")) {
	function MSU_SensusAccess($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "sensusaccess");
		
		ob_start();
		?>
		<iframe title="SensusAccess Document Conversion Service" src="https://www.sensusaccess.com/web3/montclair/" width="100%" height="1000" style="width: 100%; height: 1000px; border: none; box-sizing: border-box;" frameborder="0">You are unable to see the content in this frame. <a href="https://www.sensusaccess.com/web3/montclair/">Visit SensusAccess Document Conversion Service here.</a>.</iframe>
		<?PHP 
		$retval = ob_get_contents();
		ob_end_clean();
		
		
		return $retval;
	}

	add_shortcode("sensusaccess", "MSU_SensusAccess");
	$GLOBALS["MLTS_fix_codes"][]="sensusaccess";
}

if (!function_exists("MSU_CountdownShortcode")) {
	function MSU_CountdownShortcode($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("enddate"=>"", "endtime"=>"00:00:00", "timezone"=>"America/New_York", "label"=>""), $atts, "countdown");

		$datestr = $a["enddate"]." ".$a["endtime"];
		$origTimezone = date_default_timezone_get();
		$tzSet = date_default_timezone_set($a["timezone"]);

		if (!$tzSet) {
			date_default_timezone_set($origTimezone);
			return ("<p><em>ERROR: Unable to set timezone</em></p>");
		}

		$ts = strtotime($datestr);
		date_default_timezone_set($origTimezone);

		if ($ts === false) {
			return ("<p><em>ERROR: Unable to parse end date or time</em></p>");
		}

		$retval = "";
		$retval .= "<span class='item'><span class='number'>0</span><span class='unit'>days</span></span>";
		$retval .= "<span class='item'><span class='number'>0</span><span class='unit'>hours</span></span>";
		$retval .= "<span class='item'><span class='number'>0</span><span class='unit'>minutes</span></span>";
		$retval .= "<span class='item'><span class='number'>0</span><span class='unit'>seconds</span></span>";

		$retval = sprintf("<span class='countdown' data-end-timestamp='%s'><span class='header'>%s</span><span class='output'>%s</span></span>",
			date("r", $ts),
			htmlspecialchars($a["label"]),
			$retval
			);
		
		
		return $retval;
	}

	add_shortcode("countdown", "MSU_CountdownShortcode");
	$GLOBALS["MLTS_fix_codes"][]="countdown";
}

if (!function_exists("MSU_IconBin")) {
	function MSU_IconBin($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "iconbin");
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);
		
		$retval = "<div class=\"icon-bin\">".$content."</div>";		
		
		return $retval;
	}

	add_shortcode("iconbin", "MSU_IconBin");
	$GLOBALS["MLTS_fix_codes"][]="iconbin";
}

if (!function_exists("MSU_PivotFrame")) {
	function MSU_PivotFrame($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "pivotframe");

		$retval = "<iframe style='width: 100%; height: 800px;' src='https://pivot.proquest.com/embedded/79611b39290141e9843ed1d75de8f0f3' frameborder='0' title='Funding from Pivot'></iframe>";

		return $retval;
	}

	add_shortcode("pivotframe", "MSU_PivotFrame");
	$GLOBALS["MLTS_fix_codes"][]="pivotframe";
}

if (!function_exists("MSU_LastUpdatedShortcode")) {
	function MSU_LastUpdatedShortcode($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("class"=>"", "background"=>"", "poster"=>"", "fixed"=>"false"), $atts, "lastupdated");
		
		$d = get_the_modified_date("l, F j, Y g:i a", get_post());
		
		$retval = sprintf("<p><em>Last Modified: %s</em></p>", $d);
		
		return $retval;
	}

	add_shortcode("lastupdated", "MSU_LastUpdatedShortcode");
	$GLOBALS["MLTS_fix_codes"][]="lastupdated";
}

if (!function_exists("MSU_MoreInfoLink")) {
	function MSU_MoreInfoLink($atts, $content) {
		// get attributes
		$a = shortcode_atts(array(), $atts, "moreinfolink");
		
		// get content
		$content = force_balance_tags($content);
		$content = str_replace("<p></p>", "", $content);
		$content = do_shortcode($content);		
		
		return sprintf("<p class=\"more-info-link\">%s</p>", $content);
	}

	add_shortcode("moreinfolink", "MSU_MoreInfoLink");
	$GLOBALS["MLTS_fix_codes"][]="moreinfolink";
}


if (!function_exists("MSU_HouseAd")) {
	function MSU_HouseAd($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("headline"=>"", "subhead"=>"", "link"=>""), $atts, "housead");
		
		// build the tag's class name as default + $a["class"]
		$class = "mlt-band".(empty($a["class"])?"":" ".$a["class"]);
		
		$output = "";
		
		// build HTML
		$matches = array();
		if (@preg_match('/< *img[^>]*src *= *["\']?([^"\']*)/i', $content, $matches)) {
			// wp_enqueue_script("picturefill");

			$thumbID = mpGetIDFromURL($matches[1]);
			$ImageURL = wp_get_attachment_image_src($thumbID, "full");
			$ImageURL = $ImageURL[0];

			// For SVG or GIF images, we should assume that the editor does not want the images resized and saved as JPEG. 
			// This will preserve vectors in SVG and animation in GIF. 
			if (preg_match("/svg\$/i", $ImageURL)) {
				return "";
			} else if (preg_match("/gif\$/i", $ImageURL)) {
				return "";
			} else {
				$output .= getResponsiveImageTag($ImageURL, true);
			}
		} else {
			return "";
		}

		// wordmark removed 2/7/2022
		/*
		$wordmarkloc = str_replace(get_site_url(), "", get_template_directory_uri())."/msu-wordmark-stacked.png";
		$output .= sprintf("<div class='wordmark'><img class='mlt-responsive-image' src='/responsive-media/cache%s.0.1x.generic.jpg' data-original-image='%s' alt='' /></div>",
			$wordmarkloc, $wordmarkloc);
		*/

		$retval = sprintf("<div class=\"homepage-house-ad\">%s<div class='content-holder'><a href='%s'><span class='headline'>%s</span><span class='subhead'>%s</span></a></div></div>", 
			$output, $a["link"], $a["headline"], $a["subhead"]);

			
		return $retval;
	}

	add_shortcode("housead", "MSU_HouseAd");
	$GLOBALS["MLTS_fix_codes"][]="housead";
}

if (!function_exists("MSU_SlateFormSelector")) {
	function MSU_SlateFormSelector($atts, $content) {
		$a = shortcode_atts(array("id1"=>"", "id2"=>"", "server1"=>"", "server2"=>"", "label1"=>"", "label2"=>"", "headline"=>""), $atts, "slate_select");

		if (!isset($a["id1"]) || empty($a["id1"])) return "<p><em>Invalid ID 1 supplied for Slate form.</em></p>";
		if (!isset($a["id2"]) || empty($a["id2"])) return "<p><em>Invalid ID 2 supplied for Slate form.</em></p>";

		if (!isset($a["server1"]) || empty($a["server1"])) return "<p><em>Invalid server 1 specified in Slate form.</em></p>";
		if (!isset($a["server2"]) || empty($a["server2"])) return "<p><em>Invalid server 2 specified in Slate form.</em></p>";

		if (!isset($a["label1"]) || empty($a["label1"])) return "<p><em>Missing label 1 for Slate form.</em></p>";
		if (!isset($a["label2"]) || empty($a["label2"])) return "<p><em>Missing label 2 for Slate form.</em></p>";

		if (!isset($a["headline"]) || empty($a["headline"])) return "<p><em>Missing headline for Slate form selector.</em></p>";
		
		$retval = sprintf("
			<div class=\"slate-form-selector\" \n
				data-server1=\"graduate.montclair.edu\" data-id1=\"f7f8e747-a6df-4f1e-b9ae-b752d60653d0\"\n
				data-server2=\"apply.montclair.edu\" data-id2=\"1fd4d4d6-27e3-41e8-9701-63b90e68a0d8\">\n
				<div class=\"selector-scrim\">\n
					<p class=\"headline\">Get More Information</p>\n
					<p class=\"buttons\">\n
						<span class=\"prpl-button ghost-red full-width\"><a href=\"#\">Graduate Programs</a></span>\n
						<span class=\"prpl-button ghost-red full-width\"><a href=\"#\">Undergraduate Programs</a></span>\n
					</p>\n
				</div>\n
			</div>",$a["server1"], $a["id1"], $a["server2"], $a["id2"], $a["headline"], $a["label1"], $a["label2"]);

		return $retval;
	}

	add_shortcode("slate_select", "MSU_SlateFormSelector");
	$GLOBALS["MLTS_fix_codes"][] = "slate_select";
}

if (!function_exists("MSU_SlateForm")) {
	function MSU_SlateForm($atts, $content) {
		$a = shortcode_atts(array("id"=>"", "prefill"=>"", "filters"=>"","server"=>"apply.montclair.edu"), $atts, "slate_form");

		if (!isset($a["id"]) || empty($a["id"])) return "<p><em>Invalid ID supplied for Slate form.</em></p>\n";

		$retval = sprintf("<div id=\"form_%s\">Loading...</div><script>/*<![CDATA[*/var script = document.createElement('script'); script.async = 1; script.src = 'https://%s/register/?id=%s&output=embed&div=form_%s&%s' + ((location.search.length > 1) ? '&' + location.search.substring(1) : ''); var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(script, s);/*]]>*/</script>",
			$a["id"], $a["server"], $a["id"],$a["id"], $a["prefill"]);

		if ($a["filters"]) {
			ob_start();
			?>
			<script>
				(function() {
					var tmpData = {"id": "form_<?PHP echo $a["id"];?>"};
					tmpData.filters = new Object;
					<?PHP 
					$filterList = explode("&", $a["filters"]);
					foreach ($filterList as $f) {
						list($key,$val) = explode("=", $f);
						$val = explode(",", $val);
						foreach ($val as $i=>$j) {
							$val[$i] = sprintf("\"%s\"", trim($j));
						}
						echo sprintf("tmpData.filters[\"%s\"] = new Array(%s);",
							$key, implode(",", $val));
					}

					?>

					if (!("MSU_SlateFormList" in window)) {
						window.MSU_SlateFormList = new Array();
					}
					window.MSU_SlateFormList.push(tmpData);
				})();
			</script>
			<?PHP
			$retval .= ob_get_contents();
			ob_end_clean();
		}
		
		return $retval;
	}

	add_shortcode("slate_form", "MSU_SlateForm");
	$GLOBALS["MLTS_fix_codes"][]="slate_form";
}


if (!function_exists("MSU_JotForm")) {
	function MSU_JotForm($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("id"=>"", "title"=>""), $atts, "jotform");

		// sanity check the ID
		if (!isset($a["id"]) || !is_numeric($a["id"])) {
			return "<p><em>Error: Jot form requires numeric ID</em></p>";
		}

		// force there to be a title
		if (!isset($a["title"]) || empty($a["title"])) $a["title"] = "Embedded jot form";

		$retval = sprintf("<iframe  id=\"JotFormIFrame-%d\" src=\"https://form.jotform.com/%d\" title=\"%s\" frameborder=\"0\" class=\"jot-form\"  style=\"%s\" scrolling=\"no\"></iframe>",
			$a["id"], $a["id"], esc_attr($a["title"]), "min-width:100%;max-width:100%;height:539px;border:none;");

		
		return $retval;
	}

	add_shortcode("jotform", "MSU_JotForm");
	$GLOBALS["MLTS_fix_codes"][]="jotform";
}


if (!function_exists("MSU_AlumniNXTForm")) {
	function MSU_AlumniNXTForm($atts, $content) {
		// get attributes
		$a = shortcode_atts(array("id"=>"", "customerID"=>"p-7L0L2Kmi5E20-W0_FNuShQ"), $atts, "nxt_form");

		if (!isset($a["id"]) || empty($a["id"])) return "<p><em>Error: NXT Form ID not provided</em></p>";
		if (gettype($a["id"]) != "string") return "<p><em>Error: NXT Form ID must be text</em></p>";
		if (preg_match("/^[A-Za-z0-9-_]*$/", $a["id"]) == 0) return "<p><em>Error: Unexpected NXT Form ID format</em></p>";

		// create the HTML where the form will live
		$retVal = sprintf("<div id=\"blackbaud-donation-form_%s\"></div>", $a["id"]);
		
		// create the inline JavaScript that will initialize the form
		$inlineScript = sprintf("BBDonorFormLoader.newBlackbaudDonationFormZoned('renxt', '%s', '%s', 'usa')", $a["customerID"], $a["id"]);
		
		// register a new script to load at the bottom of the page
		wp_register_script("nxt-form-loader", "https://sky.blackbaudcdn.net/static/donor-form-loader/2/main.js", array("prpl-main"), "1.0", true);
		
		// attach the inline script to the newly registered script
		wp_add_inline_script("nxt-form-loader", $inlineScript, "after");

		// queue the new script at the bottom of the page
		wp_enqueue_script("nxt-form-loader");

		// return the HTML to put onto the page where the tag is
		return $retVal;

	}

	add_shortcode("nxt_form", "MSU_AlumniNXTForm");
	$GLOBALS["MLTS_fix_codes"][]="nxt_form";
}
?>