<?php
/**
 * The Template for displaying all single posts.
 *
 */
if (!function_exists("get_header")) exit("Wordpress not loaded.");


get_header(); 

	$HeaderImage = null;
	$thumbURL = null;
	$opt = get_option("page_for_posts");
	if ($opt != "0") {
		$news_home_post = get_post(get_option('page_for_posts'));
		$news_home_post->permalink = get_permalink($news_home_post->ID);
		if (has_post_thumbnail($news_home_post->ID)) {
			$thumbID = get_post_thumbnail_id($news_home_post->ID);
			$alt = get_post_meta($thumbID , '_wp_attachment_image_alt', true);
			$thumbURL = wp_get_attachment_url($thumbID);
			$HeaderImage = $thumbURL;
			$thumbURL = preg_replace("/^http[s]?:\\/\\/[^\\/]+/i", "", $thumbURL);
			$thumbURL = "/responsive-media/cache".$thumbURL.".0.1x.generic.jpg";
		}
	} else {
		$news_home_post = new stdClass();
		$news_home_post->permalink = get_bloginfo("url");
		$news_home_post->post_title = get_bloginfo("title");
		$HeaderImage = '/wp-content/themes/msu-prpl/default-header.jpg';
		$thumbURL = "/responsive-media/cache".$HeaderImage.".0.1x.generic.jpg";
		$alt = "Photo of University Hall";
	}



?>

<?PHP			
if (have_posts()) {

	while (have_posts()) {
		the_post();	
		?>
	
		<main><div class="page-middle short-hero">
			<div class="prpl-menu-column">
				<nav class="prpl-left-menu" aria-label="Category Menu">
					<?PHP 
					if (isset($LeftMenu)) {
						echo ($LeftMenu);
					} else {
						?>
						<p><a href="<?PHP echo $news_home_post->permalink;?>"><?PHP echo $news_home_post->post_title;?></a></p>
						<?PHP 
							$current_category = get_the_category();
							if (!isset($current_category["cat_ID"])) $current_category["cat_ID"] = null;
							$str = wp_list_categories(array("echo"=>0,"current_category"=>$current_category["cat_ID"]));
							$str = mb_substr($str, mb_stripos($str, "<ul"));
							$str = str_replace("current-cat", "current-page", $str);
							echo($str);
					}
					?>
					<?PHP 
						$twitterURL = "https://twitter.com/intent/tweet?text=".rawurlencode(get_the_title())."&url=".rawurlencode(get_the_permalink());
						$facebookURL = "https://www.facebook.com/sharer.php?u=".rawurlencode(get_the_permalink())."&t=".rawurlencode(get_the_title());
					?>
					<div class="news-sharing-icons">
						<a target="_blank" href="<?PHP echo $facebookURL;?>" class="facebook" aria-label="Share on Facebook"><svg viewbox="0 0 30 30"><use xlink:href="#facebook" /></svg></svg></a><!-- facebook -->
						<a target="_blank" href="<?PHP echo $twitterURL;?>" class="twitter" aria-label="Share on Twitter"><svg viewbox="0 0 30 30"><use xlink:href="#x-twitter" /></svg></svg></a><!-- twitter -->
						<a href="javascript: window.print();" class="print" aria-label="Print"><svg viewbox="0 0 100 100"><use xlink:href="#print" /></svg></a><!-- print -->
					</div>
				</nav>
			</div>
			<div class="prpl-hero short" <?PHP if ($thumbURL) echo("style=\"background-image: url(".$thumbURL.")\""); ?>>
			<?PHP 
			if ($thumbURL) {
				?>
			<img 
					class="mlt-responsive-background"
					src="<?PHP echo $thumbURL;?>" 
					data-original-image="<?PHP echo $HeaderImage;?>" 
					alt="<?PHP echo $alt; ?>"/>
			<?PHP } ?>
				<?PHP if (!boolval(get_option("RepositionH1"))) echo sprintf("<div class=\"header-scrim\"><div class=\"decorative-heading\">%s</div></div>", $news_home_post->post_title); ?>
			</div>
			<div class="prpl-content-column">

				<div class="prpl-band"><div class="prpl-band-content">
					<article class="news-article">
					<header><div class="article-date"><?PHP the_date(); ?></div>
					<h1 class="news-headline" id="content-start"><?PHP the_title(); ?></h1>
					<?PHP 
						if (has_excerpt()) {
							?>
							<div class="news-lead"><?PHP the_excerpt(); ?></div>
							<?PHP 
						}
					?>
					<p class="posted-in">Posted in: <?PHP echo get_the_category_list(", ");?></p>
					</header>

					<?PHP 
					if (has_post_thumbnail()) {
						ob_start();
						the_post_thumbnail_url("original");
						$url = ob_get_contents();
						$thumbData = get_post(get_post_thumbnail_id());
						ob_end_clean();
						?>
						<figure class="responsive-image-holder">
							<?PHP echo getResponsiveImageTag($url, false); ?>
							<figcaption><?PHP echo $thumbData->post_excerpt; ?></figcaption>
						</figure>
						<?PHP
					}
					?>

					<?PHP the_content(); ?>

					<?PHP 
						// Check the Display Related Posts theme option
						if (boolval(get_option("DisplayRelated"))) {

							// initialize some local variables
							$currTag = 0;
							$postsList = array();
							$maxPosts = 3;

							// get the tags associated with the current post
							$tags = wp_get_post_tags($post->ID);

							// if the current post has tags
							if ($tags && is_array($tags)) {

								// chew through each tag and look for posts until we get three posts or run out of tags
								while (($currTag < count($tags)) && ($maxPosts >= count($postsList))) {
									// build a query for the current tag
									$first_tag = $tags[$currTag]->term_id;
									$args=array(
										'tag__in' => array($first_tag),
										'post__not_in' => array($post->ID),
										'posts_per_page'=>3,
										'caller_get_posts'=>1
									);
									$my_query = new WP_Query($args);

									// if we got posts, concatenate with any we found from previous tags
									if ($my_query->have_posts()) {
										$postsList = array_merge($postsList, $my_query->posts);
									}

									// move to the next tag
									$currTag++;
								}

								// if we found related posts
								if (count($postsList)>0) {
									// trim down to our maximum amount of posts
									$postsList = array_slice($postsList, 0, $maxPosts);

									// output container
									echo ("<div class='related-posts'>");
									echo ("<h2>Related Posts</h2>");
									echo ("<div class=\"prpl-row\">");

									// output each related post
									foreach ($postsList as $p) {
										echo ("<div class=\"prpl-column one-third\">");

										// post thumbnail
										echo ("<div class=\"image-wrapper mlt-background-cover\">");
										if (has_post_thumbnail($p->ID)) {
											$url = get_the_post_thumbnail_url($p->ID, "original");
											echo getResponsiveImageTag($url, true);
										}
										echo ("</div>");

										// link & title
										echo ("<a href=\"".get_permalink($p->ID)."\">");
										echo (htmlspecialchars($p->post_title));
										echo ("</a>");

										echo ("</div>");
									}
									// close container 
									echo ("</div>");
									echo ("</div>");
								}			
								// reset query back to the post we were originally displaying
								wp_reset_query();
							}							
						}


						?>

					</article>
				</div></div>
			</div>
		</div></main>
		<?PHP

	}
}
?>

<?PHP
get_footer(); 
?>
