#!/bin/sh

# Clean and rebuild directories
rm -rf ./build
mkdir ./build
mkdir ./build/enyo
mkdir ./build/lib
mkdir ./build/lib/layout
mkdir ./build/lib/onyx

#Build Enyo
cd $(dirname $0)
../enyo/tools/minify.sh package-enyo.js -no-alias -output ./build/enyo/enyo

#Build Layout
cd $(dirname $0)
../enyo/tools/minify.sh package-layout.js -no-alias -output ./build/lib/layout/layout

#Build Onyx
cd $(dirname $0)
../enyo/tools/minify.sh package-onyx.js -no-alias -output ./build/lib/onyx/onyx

#Copy Onyx UI Images
mkdir ./build/lib/onyx/images
cp -r ../lib/onyx/images/* ./build/lib/onyx/images

# Clean up (fix Onyx CSS URLs, make package files for onyx and layout)
if command -v node >/dev/null 2>&1; then
	node "cleanup-script.js"
else
	echo "No node found in path"
	exit 1
fi

