@ECHO OFF

REM Clean and rebuild directories
CALL rd /S /Q .\build
CALL mkdir .\build
CALL mkdir .\build\enyo
CALL mkdir .\build\lib
CALL mkdir .\build\lib\layout
CALL mkdir .\build\lib\onyx

REM Build Enyo
REM FIXME: minify has a problem if 'package.js' is not in CWD, hence push, cd, pop
PUSHD "%CD%"
CD "%~dp0"
CALL rd /S /Q .\build\enyo
CALL ..\enyo\tools\minify.bat package-enyo.js -no-alias -output .\build\enyo\enyo %*
POPD

REM Build Layout
REM FIXME: minify has a problem if 'package.js' is not in CWD, hence push, cd, pop
PUSHD "%CD%"
CD "%~dp0"
CALL ..\enyo\tools\minify.bat package-layout.js -no-alias -output .\build\lib\layout\layout %*
POPD

REM Build Onyx
REM FIXME: minify has a problem if 'package.js' is not in CWD, hence push, cd, pop
PUSHD "%CD%"
CD "%~dp0"
CALL ..\enyo\tools\minify.bat package-onyx.js -no-alias -output .\build\lib\onyx\onyx %*
POPD

REM Copy Onyx UI Images
CALL mkdir .\build\lib\onyx\images
CALL xcopy ..\lib\onyx\images\* .\build\lib\onyx\images

REM Clean up (fix Onyx CSS URLs, make package files for onyx and layout)
CALL node.exe .\cleanup-script.js